<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('productos', function (Blueprint $table) {
            $table->integer('id_producto')->autoIncrement();
            $table->integer('id_tipo_presentacion');
            $table->integer('id_unidad_medida');
            $table->string('nombre', 800);
            $table->string('codigo_barras', 100)->nullable();
            $table->string('descripcion', 100)->nullable();
            $table->decimal('precio', 9, 2)->nullable();
            $table->decimal('precio_mayorista', 9, 2)->nullable();
            $table->decimal('precio_compra', 9, 2)->nullable();
            $table->decimal('utilidad', 9, 2)->nullable();
            $table->string('tipo_producto', 15)->nullable();
            $table->date('fecha_vencimiento')->nullable();
            $table->string('lote', 800)->nullable();
            $table->string('situacion_impuesto', 15)->nullable(); //AFECTO, INAFECTO, EXONERADO
            $table->string('tipo_impuesto', 5)->nullable(); //IGV, ISC
            $table->decimal('valor_impuesto', 9, 2)->nullable();
            $table->tinyInteger('icbper')->default('0');
            $table->string('url_imagen', 50)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_tipo_presentacion')->references('id_tipo_presentacion')->on('tipo_presentacion');
            $table->foreign('id_unidad_medida')->references('id_unidad_medida')->on('unidad_medida');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('productos');
    }
}
