<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Venta;
use App\Models\Contingencia;
use App\Models\GuiaRemision;
use App\Models\DetalleVenta;
use App\Models\DetalleContingencia;
use App\Models\Resumen;
use App\Models\DetalleResumen;
use App\Models\Empresa;
use App\Models\Local;
use App\Models\Nota;
use App\Models\ProductoLocal;
use App\Models\Baja;
use App\Models\VentasCredito;
use App\Models\DetalleGuiaRemision;

class XmlController extends Controller
{
    public function crearLlaves(){
        obtenerArchivosPEM();
    }

    public function crearComprobante($id)
    {
        $venta = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where(['id_venta' => $id , 'estado' => 1])->first();
        $detalles = DetalleVenta::with(['producto'])->where(['id_venta' => $id , 'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        $cuotas = VentasCredito::where(['id_venta' => $id , 'estado' => 1])->get();         //CUOTAS
        
        $array['comprobante']['nombre_cliente'] = $venta->cliente->nombre;
        $array['comprobante']['num_doc_cliente'] = $venta->cliente->numero_documento;
        $array['comprobante']['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo; // 1 DNI | 6 RUC
        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo; // 01 FACTURA | 03 BOLETA
        $array['comprobante']['fecha'] = $venta->fecha_venta;
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;
        $array['comprobante']['nro_cuotas'] = $venta->numero_cuotas; //CUOTAS
        $array['comprobante']['hora'] = date("H:i:s", strtotime($venta->created_at));

        $array['comprobante']['descuento_global'] = $venta->descuento_global;
        $array['comprobante']['igv_total'] = $venta->igv_total;
        $array['comprobante']['gravado_total'] = $venta->gravado_total;


        // Inicio Tipo Pago
        if ($venta->tipo_pago == "EFECTIVO" || $venta->tipo_pago == "TARJETA" || $venta->tipo_pago == "LIQUIDACION") { $array['comprobante']['tipo_pago'] = 'Contado'; }
        else { $array['comprobante']['tipo_pago'] = 'Credito'; }
        // Fin Tipo Pago

        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;
        

        $total_icbper = 0;
        $impuesto = 0;
        $subtotal = 0;
        
        $i = 0;
        $K = 0; //CUOTAS

        $array['comprobante']['afecto'] = 0;
        $array['comprobante']['exonerado'] = 0;
        $array['comprobante']['inafecto'] = 0;
        $array['comprobante']['subtotal_afecto'] = 0;
        $array['comprobante']['impuesto_afecto'] = 0;
        $array['comprobante']['subtotal_exonerado'] = 0;
        $array['comprobante']['impuesto_exonerado'] = 0;
        $array['comprobante']['subtotal_inafecto'] = 0;
        $array['comprobante']['impuesto_inafecto'] = 0;
        $array['comprobante']['tiene_icbper'] = 0;
        $array['comprobante']['valor_icbper'] = $empresa->valor_icbper;
        $array['comprobante']['total_afecto'] = 0;

        //CUOTAS
        foreach ($cuotas as $row2) {
            $array['cuotas'][$K]['nombre_cuota'] = $row2->nombre_cuota;
            $array['cuotas'][$K]['monto_cuota'] = $row2->monto_cuota;
            $array['cuotas'][$K]['fecha_pago_cuota'] = $row2->fecha_pago_cuota;
            $K++;
        }

        foreach ($detalles as $row) {
            
            $array['detalle'][$i]['id_producto'] = $row->id_producto;
            $array['detalle'][$i]['cantidad'] = $row->cantidad;
            $array['detalle'][$i]['descripcion'] = $row->producto->nombre;
            $array['detalle'][$i]['precio_unitario'] = $row->precio_venta; // precio unitario incluido IGV
            $array['detalle'][$i]['precio_unitario_neto'] = number_format($row->precio_venta/(1+($row->producto->valor_impuesto/100)), 6, ".", ""); 
            $array['detalle'][$i]['subtotal'] = number_format($row->precio_venta_neto, 2, ".", "");
            $array['detalle'][$i]['impuesto'] = number_format($row->impuesto, 2, ".", "");

            $array['detalle'][$i]['descuento'] = number_format($row->descuento, 2, ".", "");
            $array['detalle'][$i]['descuento_neto'] = number_format($row->descuento/(1+($row->producto->valor_impuesto/100)), 2, ".", ""); 
            $array['detalle'][$i]['subtotal_descuento'] = number_format(($row->cantidad*$row->precio_venta)/(1+($row->producto->valor_impuesto/100)), 2, ".", ""); 
            $array['detalle'][$i]['factor_descuento'] = number_format(($row->descuento/(1+($row->producto->valor_impuesto/100)))/(($row->cantidad*$row->precio_venta)/(1+($row->producto->valor_impuesto/100))), 5, ".", "");

            $array['detalle'][$i]['valor_impuesto'] = $row->producto->valor_impuesto;
            $array['detalle'][$i]['situacion_impuesto'] = $row->producto->situacion_impuesto; // afecto, inafecto, exonerado
            

            if ($row->producto->situacion_impuesto == "AFECTO") {
                $array['comprobante']['afecto'] = 1;
                $array['comprobante']['subtotal_afecto'] = $array['comprobante']['subtotal_afecto'] + $row->precio_venta_neto;
                $array['comprobante']['impuesto_afecto'] = $array['comprobante']['impuesto_afecto'] + $row->impuesto;
                $array['comprobante']['total_afecto'] = $array['comprobante']['total_afecto'] + $row->precio_venta_total;
            }
            else if ($row->producto->situacion_impuesto == "EXONERADO") {
                $array['comprobante']['exonerado'] = 1;
                $array['comprobante']['subtotal_exonerado'] = $array['comprobante']['subtotal_exonerado'] + $row->precio_venta_neto;
                $array['comprobante']['impuesto_exonerado'] = $array['comprobante']['impuesto_exonerado'] + $row->impuesto;
            }
            else if ($row->producto->situacion_impuesto == "INAFECTO") {
                $array['comprobante']['inafecto'] = 1;
                $array['comprobante']['subtotal_inafecto'] = $array['comprobante']['subtotal_inafecto'] + $row->precio_venta_neto;
                $array['comprobante']['impuesto_inafecto'] = $array['comprobante']['impuesto_inafecto'] + $row->impuesto;
            }

            $array['detalle'][$i]['tiene_icbper'] = $row->producto->icbper;
            if ($row->producto->icbper == 1) {
                $array['comprobante']['tiene_icbper']= 1;
                $array['detalle'][$i]['cantidad_icbper'] = number_format($row->cantidad, 0, ".", "");
                $array['detalle'][$i]['subtotal_icbper'] = $row->cantidad*$empresa->valor_icbper;
                $total_icbper = $total_icbper + $row->cantidad*$empresa->valor_icbper;
            }

            $impuesto = $impuesto + $row->impuesto;
            $subtotal = $subtotal + $row->precio_venta_neto;

            $i++;
        }


        $array['comprobante']['subtotal_afecto'] = number_format($array['comprobante']['subtotal_afecto'], 2, ".", "");
        $array['comprobante']['impuesto_afecto'] = number_format($array['comprobante']['impuesto_afecto'], 2, ".", "");
        $array['comprobante']['subtotal_exonerado'] = number_format($array['comprobante']['subtotal_exonerado'], 2, ".", "");
        $array['comprobante']['impuesto_exonerado'] = number_format($array['comprobante']['impuesto_exonerado'], 2, ".", "");
        $array['comprobante']['subtotal_inafecto'] = number_format($array['comprobante']['subtotal_inafecto'], 2, ".", "");
        $array['comprobante']['impuesto_inafecto'] = number_format($array['comprobante']['impuesto_inafecto'], 2, ".", "");

        $array['comprobante']['subtotal'] = number_format($subtotal, 2, ".", "");
        $array['comprobante']['impuesto'] = number_format($impuesto, 2, ".", "");
        $array['comprobante']['total_icbper'] = number_format($total_icbper, 2, ".", "");
        $array['comprobante']['total'] = number_format($venta->total_venta, 2, ".", "");

        
        $array['carpeta'] = "comprobantes";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante']."-".$array['comprobante']['nombre'];

        crearComprobanteXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);
    }

    public function crearNotaCredito($id)
    {
        $nota = Nota::with('tipo_comprobante')->where(['id_nota' => $id , 'estado' => 1])->first();

        $venta = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where(['id_venta' => $nota->id_venta])->first();
        $detalles = DetalleVenta::with(['producto'])->where(['id_venta' => $nota->id_venta, 'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        $cuotas = VentasCredito::where(['id_venta' => $nota->id_venta , 'estado' => 1])->get();  //CUOTAS

        $array['comprobante']['nombre_cliente'] = $venta->cliente->nombre;
        $array['comprobante']['num_doc_cliente'] = $venta->cliente->numero_documento;
        $array['comprobante']['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo; // 1 DNI | 6 RUC
        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo; // 01 FACTURA | 03 BOLETA
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;
        $array['comprobante']['nro_cuotas'] = $venta->numero_cuotas; //CUOTAS
        $array['comprobante']['igv_total'] = $venta->igv_total; //DESCUENTO

        // Inicio Tipo Pago
        if ($venta->tipo_pago == "EFECTIVO" || $venta->tipo_pago == "TARJETA" || $venta->tipo_pago == "LIQUIDACION") { $array['comprobante']['tipo_pago'] = 'Contado'; }
        else { $array['comprobante']['tipo_pago'] = 'Credito'; }
        // Fin Tipo Pago

        $array['nota']['nombre'] = $nota->nombre_nota;
        $array['nota']['fecha'] = $nota->fecha_emision;
        $array['nota']['hora'] = date("H:i:s", strtotime($nota->created_at));
        $array['nota']['id_motivo'] = $nota->id_motivo;
        $array['nota']['descripcion'] = $nota->descripcion;
        $array['nota']['tipo_comprobante'] = $nota->tipo_comprobante->codigo; // 07 NC | 08 ND

        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;

        
        $total_icbper = 0;
        $impuesto = 0;
        $subtotal = 0;
        $descuento_neto = 0;
        $total = 0;
        $i = 0;
        $K = 0; //CUOTAS

        $array['comprobante']['afecto'] = 0;
        $array['comprobante']['exonerado'] = 0;
        $array['comprobante']['inafecto'] = 0;
        $array['comprobante']['subtotal_afecto'] = 0;
        $array['comprobante']['impuesto_afecto'] = 0;
        $array['comprobante']['subtotal_exonerado'] = 0;
        $array['comprobante']['impuesto_exonerado'] = 0;
        $array['comprobante']['subtotal_inafecto'] = 0;
        $array['comprobante']['impuesto_inafecto'] = 0;
        $array['comprobante']['tiene_icbper'] = 0;
        $array['comprobante']['valor_icbper'] = $empresa->valor_icbper;

        $array['comprobante']['descuento_neto_afecto'] = 0;
        $array['comprobante']['descuento_exonerado'] = 0;
        $array['comprobante']['descuento_inafecto'] = 0;

        //CUOTAS
        foreach ($cuotas as $row2) {
            $array['cuotas'][$K]['nombre_cuota'] = $row2->nombre_cuota;
            $array['cuotas'][$K]['monto_cuota'] = $row2->monto_cuota;
            $array['cuotas'][$K]['fecha_pago_cuota'] = $row2->fecha_pago_cuota;
            $K++;
        }

        foreach ($detalles as $row) {
            
            $_subtotal = $row->precio_venta_total; 
            $subtotal_neto = $_subtotal/(1+($row->producto->valor_impuesto/100)); 
            $_precio_unitario = $row->precio_venta_total/$row->cantidad; 
            $_precio_unitario_neto = $_precio_unitario/(1+($row->producto->valor_impuesto/100)); 
            $impuesto_neto = $_subtotal - $subtotal_neto;

            $array['detalle'][$i]['id_producto'] = $row->id_producto;
            $array['detalle'][$i]['cantidad'] = $row->cantidad;
            $array['detalle'][$i]['descripcion'] = $row->producto->nombre;

            $array['detalle'][$i]['precio_unitario'] = $_precio_unitario;
            $array['detalle'][$i]['precio_unitario_neto'] = $_precio_unitario_neto; 
            $array['detalle'][$i]['subtotal'] = number_format($subtotal_neto, 2, ".", ""); 
            $array['detalle'][$i]['impuesto'] = number_format($impuesto_neto, 2, ".", ""); 

            //$array['detalle'][$i]['precio_unitario'] = $row->precio_venta; // precio unitario incluido IGV
            //$array['detalle'][$i]['precio_unitario_neto'] = number_format($row->precio_venta/(1+($row->producto->valor_impuesto/100)), 6, ".", ""); 
            //$array['detalle'][$i]['subtotal'] = number_format($row->precio_venta_neto, 2, ".", "");//DESCUENTO
            //$array['detalle'][$i]['impuesto'] = number_format($row->impuesto, 2, ".", "");//DESCUENTO

            $array['detalle'][$i]['descuento'] = number_format($row->descuento, 2, ".", "");
            $array['detalle'][$i]['descuento_neto'] = number_format($row->descuento/(1+($row->producto->valor_impuesto/100)), 2, ".", ""); 
            $array['detalle'][$i]['subtotal_descuento'] = number_format(($row->cantidad*$row->precio_venta)/(1+($row->producto->valor_impuesto/100)), 2, ".", ""); 
            $array['detalle'][$i]['factor_descuento'] = number_format(($row->descuento/(1+($row->producto->valor_impuesto/100)))/(($row->cantidad*$row->precio_venta)/(1+($row->producto->valor_impuesto/100))), 5, ".", "");

            $array['detalle'][$i]['valor_impuesto'] = $row->producto->valor_impuesto;
            $array['detalle'][$i]['situacion_impuesto'] = $row->producto->situacion_impuesto; // afecto, inafecto, exonerado

            if ($row->producto->situacion_impuesto == "AFECTO") {
                $array['comprobante']['afecto'] = 1;
                $array['comprobante']['subtotal_afecto'] = $array['comprobante']['subtotal_afecto'] + $subtotal_neto;
                $array['comprobante']['impuesto_afecto'] = $array['comprobante']['impuesto_afecto'] + $impuesto_neto;
                $array['comprobante']['descuento_neto_afecto'] = $array['comprobante']['descuento_neto_afecto'] + number_format($row->descuento/(1+($row->producto->valor_impuesto/100)), 2, ".", ""); 
            }
            else if ($row->producto->situacion_impuesto == "EXONERADO") {
                $array['comprobante']['exonerado'] = 1;
                $array['comprobante']['subtotal_exonerado'] = $array['comprobante']['subtotal_exonerado'] + $subtotal_neto;
                $array['comprobante']['impuesto_exonerado'] = $array['comprobante']['impuesto_exonerado'] + $impuesto_neto;
                $array['comprobante']['descuento_exonerado'] = $array['comprobante']['descuento_exonerado'] + number_format($row->descuento/(1+($row->producto->valor_impuesto/100)), 2, ".", ""); 
            }
            else if ($row->producto->situacion_impuesto == "INAFECTO") {
                $array['comprobante']['inafecto'] = 1;
                $array['comprobante']['subtotal_inafecto'] = $array['comprobante']['subtotal_inafecto'] + $subtotal_neto;
                $array['comprobante']['impuesto_inafecto'] = $array['comprobante']['impuesto_inafecto'] + $impuesto_neto;
                $array['comprobante']['descuento_inafecto'] = $array['comprobante']['descuento_inafecto'] + number_format($row->descuento/(1+($row->producto->valor_impuesto/100)), 2, ".", ""); 
            }

            $array['detalle'][$i]['tiene_icbper'] = $row->producto->icbper;
            if ($row->producto->icbper == 1) {
                $array['comprobante']['tiene_icbper']= 1;
                $array['detalle'][$i]['cantidad_icbper'] = number_format($row->cantidad, 0, ".", "");
                $array['detalle'][$i]['subtotal_icbper'] = $row->cantidad*$empresa->valor_icbper;
                $total_icbper = $total_icbper + $row->cantidad*$empresa->valor_icbper;
            }

            $impuesto = $impuesto + $impuesto_neto;
            $subtotal = $subtotal + $subtotal_neto;
            $descuento_neto = $descuento_neto + $array['detalle'][$i]['descuento_neto']; 
            $i++;
        }

        $array['comprobante']['subtotal_afecto'] = number_format($array['comprobante']['subtotal_afecto'], 2, ".", "");
        $array['comprobante']['impuesto_afecto'] = number_format($array['comprobante']['impuesto_afecto'], 2, ".", "");
        $array['comprobante']['subtotal_exonerado'] = number_format($array['comprobante']['subtotal_exonerado'], 2, ".", "");
        $array['comprobante']['impuesto_exonerado'] = number_format($array['comprobante']['impuesto_exonerado'], 2, ".", "");
        $array['comprobante']['subtotal_inafecto'] = number_format($array['comprobante']['subtotal_inafecto'], 2, ".", "");
        $array['comprobante']['impuesto_inafecto'] = number_format($array['comprobante']['impuesto_inafecto'], 2, ".", "");

        $array['comprobante']['subtotal'] = number_format($subtotal, 2, ".", "");
        $array['comprobante']['impuesto'] = number_format($impuesto, 2, ".", "");
        $array['comprobante']['total_icbper'] = number_format($total_icbper, 2, ".", "");
        $array['comprobante']['total'] = number_format($venta->total_venta, 2, ".", "");
        $array['comprobante']['descuento_neto'] = number_format($descuento_neto, 2, ".", "");
        
        $array['carpeta'] = "notas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['nota']['tipo_comprobante']."-".$array['nota']['nombre'];

        crearNotaCreditoXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);
    }

    public function crearNotaDebito($id)
    {
        $nota = Nota::with('tipo_comprobante')->where(['id_nota' => $id , 'estado' => 1])->first();

        $venta = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where(['id_venta' => $nota->id_venta , 'estado' => 1])->first();
        $detalles = DetalleVenta::with(['producto'])->where(['id_venta' => $nota->id_venta, 'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['nombre_cliente'] = $venta->cliente->nombre;
        $array['comprobante']['num_doc_cliente'] = $venta->cliente->numero_documento;
        $array['comprobante']['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo; // 1 DNI | 6 RUC
        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo; // 01 FACTURA | 03 BOLETA
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;

        $array['nota']['nombre'] = $nota->nombre_nota;
        $array['nota']['fecha'] = $nota->fecha_emision;
        $array['nota']['hora'] = date("H:i:s", strtotime($nota->created_at));
        $array['nota']['id_motivo'] = $nota->id_motivo;
        $array['nota']['descripcion'] = $nota->descripcion;
        $array['nota']['tipo_comprobante'] = $nota->tipo_comprobante->codigo; // 07 NC | 08 ND

        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;

        $total_icbper = 0;
        $impuesto = 0;
        $subtotal = 0;
        $total = 0;
        $i = 0;

        $array['comprobante']['afecto'] = 0;
        $array['comprobante']['exonerado'] = 0;
        $array['comprobante']['inafecto'] = 0;
        $array['comprobante']['subtotal_afecto'] = 0;
        $array['comprobante']['impuesto_afecto'] = 0;
        $array['comprobante']['subtotal_exonerado'] = 0;
        $array['comprobante']['impuesto_exonerado'] = 0;
        $array['comprobante']['subtotal_inafecto'] = 0;
        $array['comprobante']['impuesto_inafecto'] = 0;
        $array['comprobante']['tiene_icbper'] = 0;
        $array['comprobante']['valor_icbper'] = $empresa->valor_icbper;


         foreach ($detalles as $row) {
            
            $_subtotal = $row->cantidad*$row->precio_venta; 
            $subtotal_neto = $_subtotal/(1+($row->producto->valor_impuesto/100)); 
            $impuesto_neto = $_subtotal - $subtotal_neto;
            $array['detalle'][$i]['id_producto'] = $row->id_producto;
            $array['detalle'][$i]['cantidad'] = $row->cantidad;
            $array['detalle'][$i]['descripcion'] = $row->producto->nombre;
            $array['detalle'][$i]['precio_unitario'] = $row->precio_venta; // precio unitario incluido IGV
            $array['detalle'][$i]['precio_unitario_neto'] = number_format($row->precio_venta/(1+($row->producto->valor_impuesto/100)), 6, ".", ""); 
            $array['detalle'][$i]['subtotal'] = number_format($subtotal_neto, 2, ".", ""); 
            $array['detalle'][$i]['impuesto'] = number_format($impuesto_neto, 2, ".", ""); 

            $array['detalle'][$i]['valor_impuesto'] = $row->producto->valor_impuesto;
            $array['detalle'][$i]['situacion_impuesto'] = $row->producto->situacion_impuesto; // afecto, inafecto, exonerado

            if ($row->producto->situacion_impuesto == "AFECTO") {
                $array['comprobante']['afecto'] = 1;
                $array['comprobante']['subtotal_afecto'] = $array['comprobante']['subtotal_afecto'] + $subtotal_neto;
                $array['comprobante']['impuesto_afecto'] = $array['comprobante']['impuesto_afecto'] + $impuesto_neto;
            }
            else if ($row->producto->situacion_impuesto == "EXONERADO") {
                $array['comprobante']['exonerado'] = 1;
                $array['comprobante']['subtotal_exonerado'] = $array['comprobante']['subtotal_exonerado'] + $subtotal_neto;
                $array['comprobante']['impuesto_exonerado'] = $array['comprobante']['impuesto_exonerado'] + $impuesto_neto;
            }
            else if ($row->producto->situacion_impuesto == "INAFECTO") {
                $array['comprobante']['inafecto'] = 1;
                $array['comprobante']['subtotal_inafecto'] = $array['comprobante']['subtotal_inafecto'] + $subtotal_neto;
                $array['comprobante']['impuesto_inafecto'] = $array['comprobante']['impuesto_inafecto'] + $impuesto_neto;
            }

            $array['detalle'][$i]['tiene_icbper'] = $row->producto->icbper;
            if ($row->producto->icbper == 1) {
                $array['comprobante']['tiene_icbper']= 1;
                $array['detalle'][$i]['cantidad_icbper'] = number_format($row->cantidad, 0, ".", "");
                $array['detalle'][$i]['subtotal_icbper'] = $row->cantidad*$empresa->valor_icbper;
                $total_icbper = $total_icbper + $row->cantidad*$empresa->valor_icbper;
            }

            $impuesto = $impuesto + $impuesto_neto;
            $subtotal = $subtotal + $subtotal_neto;
            $total = $total + $_subtotal; 
            $i++;
        }

        $array['comprobante']['subtotal_afecto'] = number_format($array['comprobante']['subtotal_afecto'], 2, ".", "");
        $array['comprobante']['impuesto_afecto'] = number_format($array['comprobante']['impuesto_afecto'], 2, ".", "");
        $array['comprobante']['subtotal_exonerado'] = number_format($array['comprobante']['subtotal_exonerado'], 2, ".", "");
        $array['comprobante']['impuesto_exonerado'] = number_format($array['comprobante']['impuesto_exonerado'], 2, ".", "");
        $array['comprobante']['subtotal_inafecto'] = number_format($array['comprobante']['subtotal_inafecto'], 2, ".", "");
        $array['comprobante']['impuesto_inafecto'] = number_format($array['comprobante']['impuesto_inafecto'], 2, ".", "");

        $array['comprobante']['subtotal'] = number_format($subtotal, 2, ".", "");
        $array['comprobante']['impuesto'] = number_format($impuesto, 2, ".", "");
        $array['comprobante']['total_icbper'] = number_format($total_icbper, 2, ".", "");
        $array['comprobante']['total'] = number_format($venta->total_venta, 2, ".", "");

        $array['carpeta'] = "notas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['nota']['tipo_comprobante']."-".$array['nota']['nombre'];

        crearNotaDebitoXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);
    }

    public function crearGuia($id)
    {
        $guia = GuiaRemision::with('tipo_comprobante', 'cliente')->where(['id_guia_remision' => $id , 'estado' => 1])->first();
        $venta = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where(['id_venta' => $guia->id_venta , 'estado' => 1])->first();
       
        $detalles_venta = DetalleVenta::with(['producto'])->where(['id_venta' => $guia->id_venta , 'estado' => 1])->get();
        $detalles_guia = DetalleGuiaRemision::with(['producto'])->where(['id_guia_remision' => $id  , 'estado' => 1])->get();

        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
            
        if(!is_null($guia->id_venta)) {
            $array['comprobante']['nombre_cliente'] = $venta->cliente->nombre;
            $array['comprobante']['num_doc_cliente'] = $venta->cliente->numero_documento;
            $array['comprobante']['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo; // 1 DNI | 6 RUC
        }
        else{
            $array['comprobante']['nombre_cliente'] = $guia->cliente->nombre;
            $array['comprobante']['num_doc_cliente'] = $guia->cliente->numero_documento;
            $array['comprobante']['tipo_doc_cliente'] = $guia->cliente->tipo_documento->codigo; // 1 DNI | 6 RUC
        }

        $array['guia']['tipo_comprobante'] = $guia->tipo_comprobante->codigo; // 09 transportista | 31 remitente
        $array['guia']['fecha'] = $guia->fecha_emision;
        $array['guia']['nombre'] = $guia->nombre_guia;
        $array['guia']['motivo'] = $guia->motivo;
        $array['guia']['fecha_traslado'] = $guia->fecha_traslado;
        $array['guia']['documento_transportista'] = $guia->documento_transportista;
        $array['guia']['nombre_transportista'] = $guia->nombre_transportista;
        $array['guia']['marca_placa'] = $guia->marca_placa;
        $array['guia']['licencia'] = $guia->licencia;
        $array['guia']['punto_llegada'] = $guia->punto_llegada;
        $array['guia']['punto_partida'] = $guia->punto_partida;

        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;

        $i = 0;

        

        if(!is_null($guia->id_venta))
        {
            foreach ($detalles_venta as $row) {
                $array['detalle'][$i]['id_producto'] = $row->id_producto;
                $array['detalle'][$i]['cantidad'] = $row->cantidad;
                $array['detalle'][$i]['descripcion'] = $row->producto->nombre;
                $i++;
            }
        }
        else{
            foreach ($detalles_guia as $row) {
                $array['detalle'][$i]['id_producto'] = $row->id_producto;
                $array['detalle'][$i]['cantidad'] = $row->cantidad;
                $array['detalle'][$i]['descripcion'] = $row->producto->nombre;
                $i++;
            }
        }

        $array['carpeta'] = "guias";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['guia']['tipo_comprobante']."-".$array['guia']['nombre'];

        crearGuiaXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);
    }

    public function crearBaja($id)
    {  
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        $baja = Baja::with(['tipo_comprobante'])->where(['id_baja' => $id, 'estado' => 1])->first(); 
        $bajas = Baja::where('id_baja','<>',$id)->where(['fecha_emision' => date("Y-m-d"), 'estado' => 1])->get();

        $i = count($bajas)+1; 

        $array['baja']['fecha_referencia'] = $baja->fecha_referencia;
        $array['baja']['nombre'] = 'RA-'.date("Ymd").'-'.$i;
        $array['baja']['fecha'] = $baja->fecha_emision;

        $array['baja']['tipo_comprobante'] = $baja->tipo_comprobante->codigo;
        $array['baja']['serie'] = $baja->serie;
        $array['baja']['numero'] = $baja->numero;
        $array['baja']['motivo'] = $baja->motivo;

        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;

        $baj = Baja::find($baja->id_baja);
        $baj->nombre_baja = $array['baja']['nombre']; 
        $baj->save();

        $array['carpeta'] = "bajas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['baja']['nombre'];

        crearBajaXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);
    }

    /*****************************************************************************************************************/
    /* ENVIO DE DOCUMENTOS
    /*****************************************************************************************************************/

    public function enviarFacturas()
    {
        //$ayer = strtotime('-1 day', strtotime(date('Y-m-d')));
        //$ayer = date('Y-m-j', $ayer);

        $ventas = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('fecha_venta','<', date('Y-m-d'))->where('estado_envio','<>','ACEPTADO')->where('estado_envio','<>','RECHAZADO')->where([ 'id_tipo_comprobante' => 1,  'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        

        if (count($ventas) > 0) 
        {
            $i = 0;
            foreach ($ventas as $row) 
            {
                $array['comprobante']['tipo_comprobante'] = $row->tipo_comprobante->codigo;
                $array['comprobante']['serie'] = $row->serie_comprobante;
                $array['comprobante']['numero'] = $row->numero_comprobante;
                $array['comprobante']['nombre'] = $row->nombre_comprobante;
                $array['empresa']['ruc'] = $empresa->ruc;
                $array['carpeta'] = "comprobantes";
                $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

                $send = enviarComprobante($array);
                if ($send['respuesta'] == "ENVIADO") {
                    $res = respuestaComprobante($array);
                    $estado  = $res["estado"];
                    $mensaje = $res["mensaje"];
                }
                if ($send['respuesta'] == "NO ENVIADO") {
                    $estado  = $send["estado"];
                    $mensaje = $send["mensaje"];
                }

                $data = Venta::find($row->id_venta);
                $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
            echo "- Facturas enviadas";

        } else{
            echo "- No hay Facturas para enviar";
        }
    }

    public function enviarNotas()
    {
        $notas = Nota::select('notas.id_nota', 'notas.nombre_nota', 'notas.serie_nota', 'notas.numero_nota', 'tipo_comprobante.codigo')->join('tipo_comprobante', 'tipo_comprobante.id_tipo_comprobante','=', 'notas.id_tipo_comprobante')->join('ventas', 'ventas.id_venta','=', 'notas.id_venta')->where([ 'ventas.estado_envio' => 'ACEPTADO' , 'ventas.id_tipo_comprobante' => 1, 'notas.estado' => 1])->where('notas.estado_envio','<>','ACEPTADO')->where('notas.estado_envio','<>','RECHAZADO')->get();

        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        if (count($notas) > 0) 
        {
            $i = 0;
            foreach ($notas as $row) 
            {
                $array['comprobante']['tipo_comprobante'] = $row->codigo;
                $array['comprobante']['serie'] = $row->serie_nota;
                $array['comprobante']['numero'] = $row->numero_nota;
                $array['comprobante']['nombre'] = $row->nombre_nota;
                $array['empresa']['ruc'] = $empresa->ruc;
                $array['carpeta'] = "notas";
                $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

                $send = enviarComprobante($array);
                if ($send['respuesta'] == "ENVIADO") {
                    $res = respuestaComprobante($array);
                    $estado  = $res["estado"];
                    $mensaje = $res["mensaje"];
                }
                if ($send['respuesta'] == "NO ENVIADO") {
                    $estado  = $send["estado"];
                    $mensaje = $send["mensaje"];
                }

                $data = Nota::find($row->id_nota);
                $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
            
            echo "- Notas de Facturas Enviadas";

        } else{
            echo "- No hay Notas de Facturas para Enviar";
        }
    }

    public function enviarGuias()
    {
        //$ayer = strtotime('-1 day', strtotime(date('Y-m-d')));
        //$ayer = date('Y-m-j', $ayer);

        $guias = GuiaRemision::with('tipo_comprobante')->where('fecha_emision','<', date('Y-m-d'))->where('estado_envio','<>','ACEPTADO')->where('estado_envio','<>','RECHAZADO')->where('estado',1)->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        if (count($guias) > 0) 
        {
            $i = 0;
            foreach ($guias as $row) 
            {
                $array['comprobante']['tipo_comprobante'] = $row->tipo_comprobante->codigo;
                $array['comprobante']['serie'] = $row->serie_guia;
                $array['comprobante']['numero'] = $row->numero_guia;
                $array['comprobante']['nombre'] = $row->nombre_guia;
                $array['empresa']['ruc'] = $empresa->ruc;
                $array['carpeta'] = "guias";
                $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

                $send = enviarComprobante($array);
                if ($send['respuesta'] == "ENVIADO") {
                    $res = respuestaComprobante($array);
                    $estado  = $res["estado"];
                    $mensaje = $res["mensaje"];
                }
                if ($send['respuesta'] == "NO ENVIADO") {
                    $estado  = $send["estado"];
                    $mensaje = $send["mensaje"];
                }

                $data = GuiaRemision::find($row->id_guia_remision);
                $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
            echo "- Guias enviadas";

        } else{
            echo "- No hay Guias para enviar";
        }
    }

    public function enviarBajas()
    {
        //$ayer = strtotime('-1 day', strtotime(date('Y-m-d')));
        //$ayer = date('Y-m-j', $ayer);

        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        $bajas = Baja::with(['local', 'tipo_comprobante'])->where('fecha_emision','<', date('Y-m-d'))->where('estado_envio', 'REGISTRADO')->where('estado',1)->get();

        if (count($bajas) > 0) 
        {
            $i = 0;
            foreach ($bajas as $row) 
            {
                $array['resumen']['nombre'] = $row->nombre_baja;
                $array['empresa']['ruc'] = $empresa->ruc;
                $array['carpeta'] = "bajas";
                $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];
                
                $send = enviarResumen($array);
                $estado  = $send["estado"];
                $mensaje = $send["mensaje"];

                //Actualizamos estados
                $data = Baja::find($row->id_baja);
                $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
            echo "- Comunicacion de Baja enviadas";

        } else{
            echo "- No hay Comunicaciones de Baja para enviar";
        }
    }

    /*****************************************************************************************************************/
    /* ENVIO DE RESUMENES
    /*****************************************************************************************************************/
    public function enviarResumen()
    {  
        $ayer = strtotime('-1 day', strtotime(date('Y-m-d')));
        $ayer = date('Y-m-d', $ayer);
        
        $today = date("Ymd");
        $hoy = date('Y-m-d');
        
        /*$ayer = '2018-11-17';
        $today = '20181117';
        $hoy = '2018-11-17';*/
        
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        $ventas = Venta::with(['tipo_comprobante'])->where('fecha_venta','<', date('Y-m-d'))->where('estado_envio', 'REGISTRADO')->where(['id_tipo_comprobante' => 2, 'estado' => 1])->get(); 

        if (count($ventas) > 0) 
        {
            $array['comprobante']['tipo'] = 2; // 2 = BOLETA | 3 = NOTA CREDITO
            $array['comprobante']['fecha'] = $ayer;
            $array['resumen']['nombre'] = 'RC-'.$today.'-1';
            $array['resumen']['fecha'] = $hoy;
            $array['resumen']['local'] = 1;
 
            $array['empresa']['ruc'] = $empresa->ruc;
            $array['empresa']['razon_social'] = $empresa->razon_social;
            $array['empresa']['representante'] = $empresa->representante;
            $array['empresa']['direccion'] = $empresa->direccion;
            $array['empresa']['ubigeo'] = $empresa->ubigeo;

            $array['comprobante']['valor_icbper'] = $empresa->valor_icbper;

            //Registramos Resumen
            $resumen = $this->registrarResumen($array);

            $i = 0;
            foreach ($ventas as $venta) 
            {
                if ($i < 499) {
                    $detalles = DetalleVenta::with(['producto'])->where(['id_venta' => $venta->id_venta, 'estado' => 1])->get();

                    $array['boleta'][$i]['tipo_comprobante'] = $venta->tipo_comprobante->codigo;
                    $array['boleta'][$i]['nombre'] = $venta->nombre_comprobante;
                    $array['boleta'][$i]['num_doc_cliente'] = $venta->cliente->numero_documento;
                    $array['boleta'][$i]['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo;
                    

                    $impuesto = 0;
                    $subtotal = 0;
                    $total = 0;

                    $array['boleta'][$i]['subtotal_afecto'] = 0;
                    $array['boleta'][$i]['subtotal_exonerado'] = 0;
                    $array['boleta'][$i]['subtotal_inafecto'] = 0;
                    $array['boleta'][$i]['cantidad_icbper'] = 0;
                    $array['boleta'][$i]['subtotal_icbper'] = 0;
                    $array['boleta'][$i]['tiene_icbper'] = 0;

                    foreach ($detalles as $row) 
                    {
                        if ($row->producto->situacion_impuesto == "AFECTO") {
                            $array['boleta'][$i]['subtotal_afecto']  = $array['boleta'][$i]['subtotal_afecto'] + $row->precio_venta_neto;
                            $impuesto = $impuesto + $row->impuesto;
                        }
                        else if ($row->producto->situacion_impuesto == "EXONERADO") {
                            $array['boleta'][$i]['subtotal_exonerado']= $array['boleta'][$i]['subtotal_exonerado'] + $row->precio_venta_neto;
                        }
                        else if ($row->producto->situacion_impuesto == "INAFECTO") {
                            $array['boleta'][$i]['subtotal_inafecto']  = $array['boleta'][$i]['subtotal_inafecto'] + $row->precio_venta_neto;
                        }
                        
                        if ($row->producto->icbper == 1) {
                            $array['boleta'][$i]['tiene_icbper'] = 1;
                            $array['boleta'][$i]['cantidad_icbper'] = $array['boleta'][$i]['cantidad_icbper'] + number_format($row->cantidad, 0, ".", "");
                            $array['boleta'][$i]['subtotal_icbper'] = $array['boleta'][$i]['subtotal_icbper'] + $row->cantidad*$empresa->valor_icbper;
                        }

                        $subtotal = $subtotal + $row->precio_venta_neto;  
                        $total = $total + $row->precio_venta_total; 
                    }

                    $array['boleta'][$i]['subtotal_afecto'] = number_format($array['boleta'][$i]['subtotal_afecto'], 2, ".", "");
                    $array['boleta'][$i]['subtotal_exonerado'] = number_format($array['boleta'][$i]['subtotal_exonerado'], 2, ".", "");
                    $array['boleta'][$i]['subtotal_inafecto'] = number_format($array['boleta'][$i]['subtotal_inafecto'], 2, ".", "");
                    $array['boleta'][$i]['subtotal'] = number_format($subtotal, 2, ".", ""); 
                    $array['boleta'][$i]['impuesto'] = number_format($impuesto, 2, ".", "");
                    
                    $array['boleta'][$i]['total'] = number_format($total, 2, ".", "");
                    //Registramos Detalle Resumen
                    $detalle_resumen= [
                        'id_resumen' => $resumen->id_resumen,
                        'id_venta' => $venta->id_venta,
                        'nombre_comprobante' => $venta->nombre_comprobante,
                        'subtotal' => number_format($subtotal, 2, ".", ""), 
                        'impuesto' => number_format($impuesto, 2, ".", ""), 
                    ];
                    DetalleResumen::create($detalle_resumen);
                }
                $i++;
            }
           
            $array['carpeta'] = "resumen";
            $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

            crearResumenXML($array);
            firmarComprobante($array);
            comprimirComprobante($array);

            //$send = enviarResumen($array);
            //$estado  = $send["estado"];
            //$mensaje = $send["mensaje"];

            // ESTADO 98
            $send = enviarResumen($array);
            if($send["code"] == "soap-env:Client.0402"){
                $estado  = "ACEPTADO";
                $mensaje = "El Comprobante ha sido aceptado";
            }
            else {
                $estado  = $send["estado"];
                $mensaje = $send["mensaje"];
            }

            //Actualizamos estados
            $resu = Resumen::find($resumen->id_resumen);
            $resu->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO 
            $resu->mensaje_envio   = $mensaje;
            $resu->save();

            

            $k = 0;
            foreach ($ventas as $venta) 
            {
                if ($k < 499) {
                    $data = Venta::find($venta->id_venta);
                    $data->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO  
                    $data->mensaje_envio   = $mensaje;
                    $data->save();
                }
                $k++;
            }

            echo "- Envio de Resumen de Boletas Procesado";
        } 

        else {
            echo "- No hay Resumen de Boletas Para enviar";
        }
        
    }

    public function enviarResumenNota()
    {  
        $ayer = strtotime('-1 day', strtotime(date('Y-m-d')));
        $ayer = date('Y-m-d', $ayer);
        
        $today = date("Ymd");
        $hoy = date('Y-m-d');
        
        /*$ayer = '2018-11-17';
        $today = '20181117';
        $hoy = '2018-11-17';*/
        
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        $notas = Nota::join('ventas', 'notas.id_nota','=', 'ventas.id_nota')->where(function ($query) use ($ayer) {
                        $query->where('notas.fecha_emision', '<', date('Y-m-d'))
                              ->where('notas.estado_envio', '=',  'REGISTRADO') 
                              ->where('notas.estado', '=',  1)  
                              ->where('ventas.id_tipo_comprobante', '=',  2)
                              ->where('ventas.id_nota', '<>',  null);
                    })->get();

        if (count($notas) > 0) 
        {
            $array['comprobante']['tipo'] = 3; // 2 = BOLETA | 3 = NOTA CREDITO
            $array['comprobante']['fecha'] = $ayer;
            $array['resumen']['nombre'] = 'RC-'.$today.'-2';
            $array['resumen']['fecha'] = $hoy;
            $array['resumen']['local'] = 1;
 
            $array['empresa']['ruc'] = $empresa->ruc;
            $array['empresa']['razon_social'] = $empresa->razon_social;
            $array['empresa']['representante'] = $empresa->representante;
            $array['empresa']['direccion'] = $empresa->direccion;
            $array['empresa']['ubigeo'] = $empresa->ubigeo;

            $array['comprobante']['valor_icbper'] = $empresa->valor_icbper;

            //Registramos Resumen
            $resumen = $this->registrarResumen($array);

            $i = 0;
            foreach ($notas as $nota) 
            {
                $venta = Venta::with('nota')->where('id_venta', $nota->id_venta)->first(); 

                $detalles = DetalleVenta::with(['producto'])->where(['id_venta' => $venta->id_venta, 'estado' => 1])->get();

                $array['boleta'][$i]['tipo_comprobante'] = $venta->tipo_comprobante->codigo;
                $array['boleta'][$i]['nombre'] = $venta->nombre_comprobante;
                $array['boleta'][$i]['num_doc_cliente'] = $venta->cliente->numero_documento;
                $array['boleta'][$i]['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo;
                
                

                $array['nota'][$i]['tipo_comprobante'] = $venta->nota->tipo_comprobante->codigo;
                $array['nota'][$i]['nombre'] = $venta->nota->nombre_nota;

                $impuesto = 0;
                $subtotal = 0;
                $total = 0;

                $array['boleta'][$i]['subtotal_afecto'] = 0;
                $array['boleta'][$i]['subtotal_exonerado'] = 0;
                $array['boleta'][$i]['subtotal_inafecto'] = 0;

                $array['boleta'][$i]['cantidad_icbper'] = 0;
                $array['boleta'][$i]['subtotal_icbper'] = 0;
                $array['boleta'][$i]['tiene_icbper'] = 0;

                foreach ($detalles as $row) 
                {
                    $_total = $row->cantidad*$row->precio_venta;
                    $neto = 1+($row->producto->valor_impuesto/100);

                    $subtotal = $subtotal + ($_total/$neto);  
                    $_impuesto = ($_total - ($_total/$neto));
                    $total = $total + $row->precio_venta_total; 

                    if ($row->producto->situacion_impuesto == "AFECTO") {
                        $array['boleta'][$i]['subtotal_afecto']  = $array['boleta'][$i]['subtotal_afecto'] + ($_total/$neto);
                        $impuesto = $impuesto + $_impuesto;
                    }
                    else if ($row->producto->situacion_impuesto == "EXONERADO") {
                        $array['boleta'][$i]['subtotal_exonerado']= $array['boleta'][$i]['subtotal_exonerado'] + ($_total/$neto);
                    }
                    else if ($row->producto->situacion_impuesto == "INAFECTO") {
                        $array['boleta'][$i]['subtotal_inafecto']  = $array['boleta'][$i]['subtotal_inafecto'] + ($_total/$neto);
                    }

                    if ($row->producto->icbper == 1) {
                        $array['boleta'][$i]['tiene_icbper'] = 1;
                        $array['boleta'][$i]['cantidad_icbper'] = $array['boleta'][$i]['cantidad_icbper'] + number_format($row->cantidad, 0, ".", "");
                        $array['boleta'][$i]['subtotal_icbper'] = $array['boleta'][$i]['subtotal_icbper'] + $row->cantidad*$empresa->valor_icbper;
                    }
                }

                $array['boleta'][$i]['subtotal_afecto'] = number_format($array['boleta'][$i]['subtotal_afecto'], 2, ".", "");
                $array['boleta'][$i]['subtotal_exonerado'] = number_format($array['boleta'][$i]['subtotal_exonerado'], 2, ".", "");
                $array['boleta'][$i]['subtotal_inafecto'] = number_format($array['boleta'][$i]['subtotal_inafecto'], 2, ".", "");

                $array['boleta'][$i]['subtotal'] = number_format($subtotal, 2, ".", ""); 
                $array['boleta'][$i]['impuesto'] = number_format($impuesto, 2, ".", "");
                $array['boleta'][$i]['total'] = number_format($total, 2, ".", "");

                $i++;

                //Registramos Detalle Resumen
                $detalle_resumen= [
                    'id_resumen' => $resumen->id_resumen,
                    'id_nota' => $venta->id_nota,
                    'nombre_comprobante' => $venta->nota->nombre_nota,
                    'subtotal' => number_format($subtotal, 2, ".", ""), 
                    'impuesto' => number_format($impuesto, 2, ".", ""), 
                ];
                DetalleResumen::create($detalle_resumen);
            }

            $array['carpeta'] = "resumen";
            $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

            crearResumenNotaXML($array);
            firmarComprobante($array);
            comprimirComprobante($array);

            //$send = enviarResumen($array);
            //$estado  = $send["estado"];
            //$mensaje = $send["mensaje"];

            // ESTADO 98
            $send = enviarResumen($array);
            if($send["code"] == "soap-env:Client.0402"){
                $estado  = "ACEPTADO";
                $mensaje = "El Comprobante ha sido aceptado";
            }
            else {
                $estado  = $send["estado"];
                $mensaje = $send["mensaje"];
            }

            //Actualizamos estados
            $resu = Resumen::find($resumen->id_resumen);
            $resu->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO 
            $resu->mensaje_envio   = $mensaje;
            $resu->save();

            foreach ($notas as $nota) 
            {
                $data = Nota::find($nota->id_nota);
                $data->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO  
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }

            echo "- Envio de Resumen de Notas Procesadas";
        } 
        else {
            echo "- No hay Resumen de Notas para Procesar";
        }
    }
   
    public function registrarResumen($array)
    {  
        $datos= [
            'id_local' => $array['resumen']['local'], 
            'nombre_resumen' => $array['resumen']['nombre'], // RC-20180715-1
            'fecha_emision' => $array['resumen']['fecha'], 
            'fecha_referencia' => $array['comprobante']['fecha'],
            'id_tipo_comprobante' => $array['comprobante']['tipo'],
        ];
        $res = Resumen::create($datos);
        return $res;
    }   
 
    /*****************************************************************************************************************/
    /* CONSULTA DE TICKETS
    /*****************************************************************************************************************/

    public function ticketResumen()
    {  
        $resumenes = Resumen::where('estado_envio','<>', 'ACEPTADO')->where(['estado' => 1])->get();  
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        if (count($resumenes) > 0) 
        {
            foreach ($resumenes as $resumen) 
            {
                $array['resumen']['nombre'] = $resumen->nombre_resumen;
                $array['empresa']['ruc'] = $empresa->ruc;
                $array['carpeta'] = "resumen";
                $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

                if ($resumen->estado_envio == "PENDIENTE") 
                {
                    $send = consultaTicketResumen($array);
                    if ($send['respuesta'] == "ENVIADO") {
                        $res = respuestaResumen($array);
                        $estado  = $res["estado"];
                        $mensaje = $res["mensaje"];
                    }
                    if ($send['respuesta'] == "NO ENVIADO") {
                        $estado  = $send["estado"];
                        $mensaje = $send["mensaje"];
                    }

                    //Actualizamos estados
                    $resu = Resumen::find($resumen->id_resumen);
                    $resu->estado_envio    = $estado ; // ACEPTADO | RECHAZADO | NO ENVIADO 
                    $resu->mensaje_envio   = $mensaje;
                    $resu->save();

                    $detalles = DetalleResumen::where(['id_resumen' => $resumen->id_resumen , 'estado' => 1])->get();

                    if ($estado == "ACEPTADO" || $estado == "NO ENVIADO" ) {
                        foreach ($detalles as $venta) 
                        {
                            if ($resu->id_tipo_comprobante == 2) {
                                $data = Venta::find($venta->id_venta);
                            }
                            if ($resu->id_tipo_comprobante == 3) {
                                $data = Nota::find($venta->id_nota);
                            }
                            
                            $data->estado_envio    = $estado ; // ACEPTADO | NO ENVIADO 
                            $data->mensaje_envio   = $mensaje;
                            $data->save();
                        }
                    } else {
                        foreach ($detalles as $venta) 
                        {
                            if ($resu->id_tipo_comprobante == 2) {
                                $data = Venta::find($venta->id_venta);
                            }
                            if ($resu->id_tipo_comprobante == 3) {
                                $data = Nota::find($venta->id_nota);
                            }
                            $data->estado_envio    = "RECHAZADO";
                            $data->mensaje_envio   = $mensaje;
                            $data->save();
                        }
                    }
                }

                if ($resumen->estado_envio == "NO ENVIADO") 
                {
                    $send = enviarResumen($array);
                    $estado  = $send["estado"];
                    $mensaje = $send["mensaje"];

                    //Actualizamos estados
                    $resu = Resumen::find($resumen->id_resumen);
                    $resu->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO 
                    $resu->mensaje_envio   = $mensaje;
                    $resu->save();

                    $detalles = DetalleResumen::where(['id_resumen' => $resumen->id_resumen , 'estado' => 1])->get();

                    foreach ($detalles as $venta) 
                    {
                        if ($resu->id_tipo_comprobante == 2) {
                            $data1 = Venta::find($venta->id_venta);
                        }
                        if ($resu->id_tipo_comprobante == 3) {
                            $data1 = Nota::find($venta->id_nota);
                        }
                        
                        $data1->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO 
                        $data1->mensaje_envio   = $mensaje;
                        $data1->save();
                    }
                }
                    
            }   
            echo "- Obtencion de CDR de Resumenes Procesado";
        } 
        else {
            echo "- No hay Tickets de Resumenes para Procesar";
        }    
    }

    public function ticketBaja()
    {  
        $bajas = Baja::where('estado_envio', '<>', 'ACEPTADO')->where('estado_envio', '<>', 'REGISTRADO')->where(['estado' => 1])->get();  
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        if (count($bajas) > 0) 
        {
            foreach ($bajas as $row) 
            {
                $array['resumen']['nombre'] = $row->nombre_baja;
                $array['empresa']['ruc'] = $empresa->ruc;
                $array['carpeta'] = "bajas";
                $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

                if ($row->estado_envio == "PENDIENTE") 
                {
                    $send = consultaTicketResumen($array);
                    if ($send['respuesta'] == "ENVIADO") {
                        $res = respuestaResumen($array);
                        $estado  = $res["estado"];
                        $mensaje = $res["mensaje"];
                    }
                    if ($send['respuesta'] == "NO ENVIADO") {
                        $estado  = $send["estado"];
                        $mensaje = $send["mensaje"];
                    }

                    //Actualizamos estados
                    $baj = Baja::find($row->id_baja);
                    $baj->estado_envio    = $estado ; // ACEPTADO | RECHAZADO | NO ENVIADO 
                    $baj->mensaje_envio   = $mensaje;
                    $baj->save();
                }

                if ($row->estado_envio == "NO ENVIADO") 
                {
                    $send = enviarResumen($array);
                    $estado  = $send["estado"];
                    $mensaje = $send["mensaje"];

                    //Actualizamos estados
                    $data = Baja::find($row->id_baja);
                    $data->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO 
                    $data->mensaje_envio   = $mensaje;
                    $data->save();
                }

            }   
            echo "- Obtencion de CDR de Bajas Procesado";
        } 
        else {
            echo "- No hay Tickets de Bajas para Procesar";
        }     
    }


    /*****************************************************************************************************************/
    /* REEEEENVIO DE DOCUMENTOS
    /*****************************************************************************************************************/

    public function reenviarFactura(Request $request)
    {  
        $this->crearComprobante($request->id);

        $venta = Venta::with(['tipo_comprobante'])->where(['id_venta' => $request->id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo;
        $array['comprobante']['serie'] = $venta->serie_comprobante;
        $array['comprobante']['numero'] = $venta->numero_comprobante;
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "comprobantes";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

        $send = enviarComprobante($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaComprobante($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        $data = Venta::find($venta->id_venta);
        $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
        $data->mensaje_envio   = $mensaje;
        $data->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }

    public function reenviarNota(Request $request)
    {  
        $nota = Nota::with('tipo_comprobante')->where(['id_nota' => $request->id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        if ($nota->id_tipo_comprobante == 3) {
            $this->crearNotaCredito($request->id);
        }
        if ($nota->id_tipo_comprobante == 4) {
            $this->crearNotaDebito($request->id);
        }

        $array['comprobante']['tipo_comprobante'] = $nota->tipo_comprobante->codigo;
        $array['comprobante']['serie'] = $nota->serie_nota;
        $array['comprobante']['numero'] = $nota->numero_nota;
        $array['comprobante']['nombre'] = $nota->nombre_nota;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "notas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

    
        $send = enviarComprobante($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaComprobante($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        //Actualizamos estados
        $data = Nota::find($nota->id_nota);
        $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
        $data->mensaje_envio   = $mensaje;
        $data->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }

    public function reenviarGuia(Request $request)
    {  
        $this->crearGuia($request->id);

        $guia = GuiaRemision::with('tipo_comprobante')->where(['id_guia_remision' => $request->id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['tipo_comprobante'] = $guia->tipo_comprobante->codigo;
        $array['comprobante']['serie'] = $guia->serie_guia;
        $array['comprobante']['numero'] = $guia->numero_guia;
        $array['comprobante']['nombre'] = $guia->nombre_guia;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "guias";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

        $send = enviarComprobante($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaComprobante($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        $data = GuiaRemision::find($guia->id_guia_remision);
        $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
        $data->mensaje_envio   = $mensaje;
        $data->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }


    public function reenviarBaja(Request $request)
    {
        $this->crearBaja($request->id);

        $baja = Baja::find($request->id);
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['resumen']['nombre'] = $baja->nombre_baja;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "bajas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

        $send = enviarResumen($array);

        $estado  = $send["estado"];
        $mensaje = $send["mensaje"];

        //Actualizamos estados
        $baja->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO
        $baja->mensaje_envio   = $mensaje;
        $baja->save();

        return response()->json($send['estado'] == "PENDIENTE" ? ['message' => 'success'] : ['message' => 'error']); 

    }


    public function reenviarResumen(Request $request)
    {  

        $resumen = Resumen::find($request->id);

        if ($resumen->id_tipo_comprobante == 2) {
            $this->crearResumen($request->id);
        }
        if ($resumen->id_tipo_comprobante == 3) {
            $this->crearResumenNota($request->id);
        }


        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['resumen']['nombre'] = $resumen->nombre_resumen;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "resumen";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];
      
        //$send = enviarResumen($array); 
        //$estado  = $send["estado"];
        //$mensaje = $send["mensaje"];

        // ESTADO 98
        $send = enviarResumen($array);
        if($send["code"] == "soap-env:Client.0402"){
            $estado  = "ACEPTADO";
            $mensaje = "El Comprobante ha sido aceptado";
        }
        else {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        //Actualizamos estados
        $resumen->estado_envio    = $estado ; //PENDIENTE | NO ENVIADO
        $resumen->mensaje_envio   = $mensaje;
        $resumen->save();

        $detalles =  DetalleResumen::where(['id_resumen' => $resumen->id_resumen, 'estado' => 1])->get();

        foreach ($detalles as $venta) 
        {
            if ($resumen->id_tipo_comprobante == 2) {
                $data = Venta::find($venta->id_venta);
            }
            if ($resumen->id_tipo_comprobante == 3) {
                $data = Nota::find($venta->id_nota);
            }
            $data->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO
            $data->mensaje_envio   = $mensaje;
            $data->save();
        }
        return response()->json(($estado == "PENDIENTE" || $estado == "ACEPTADO" ) ? ['message' => 'success'] : ['message' => 'error']); 
    }


   
    public function crearResumen($id)
    {  
        $resumen = Resumen::where(['id_resumen' => $id , 'estado' => 1])->first();
        $detalle_resumen =  DetalleResumen::with(['venta'])->where(['id_resumen' => $resumen->id_resumen, 'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['tipo'] = $resumen->id_tipo_comprobante; // 2 = BOLETA | 3 = NOTA CREDITO
        $array['comprobante']['fecha'] = $resumen->fecha_referencia;
        $array['resumen']['nombre'] = $resumen->nombre_resumen;
        $array['resumen']['fecha'] = $resumen->fecha_emision;
        $array['resumen']['local'] = $resumen->id_local;

        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;

        $array['comprobante']['valor_icbper'] = $empresa->valor_icbper;
        
        $i = 0;
        foreach ($detalle_resumen as $resu) 
        {
            $detalles = DetalleVenta::with(['producto'])->where(['id_venta' => $resu->id_venta, 'estado' => 1])->get();

            $array['boleta'][$i]['tipo_comprobante'] = $resu->venta->tipo_comprobante->codigo;
            $array['boleta'][$i]['nombre'] = $resu->venta->nombre_comprobante;
            $array['boleta'][$i]['num_doc_cliente'] = $resu->venta->cliente->numero_documento;
            $array['boleta'][$i]['tipo_doc_cliente'] = $resu->venta->cliente->tipo_documento->codigo;
            
            $impuesto = 0;
            $subtotal = 0;
            $total = 0;

            $array['boleta'][$i]['subtotal_afecto'] = 0;
            $array['boleta'][$i]['subtotal_exonerado'] = 0;
            $array['boleta'][$i]['subtotal_inafecto'] = 0;
            $array['boleta'][$i]['cantidad_icbper'] = 0;
            $array['boleta'][$i]['subtotal_icbper'] = 0;
            $array['boleta'][$i]['tiene_icbper'] = 0;

            foreach ($detalles as $row) 
            {
                if ($row->producto->situacion_impuesto == "AFECTO") {
                    $array['boleta'][$i]['subtotal_afecto']  = $array['boleta'][$i]['subtotal_afecto'] + $row->precio_venta_neto;
                    $impuesto = $impuesto + $row->impuesto;
                }
                else if ($row->producto->situacion_impuesto == "EXONERADO") {
                    $array['boleta'][$i]['subtotal_exonerado']= $array['boleta'][$i]['subtotal_exonerado'] + $row->precio_venta_neto;
                }
                else if ($row->producto->situacion_impuesto == "INAFECTO") {
                    $array['boleta'][$i]['subtotal_inafecto']  = $array['boleta'][$i]['subtotal_inafecto'] + $row->precio_venta_neto;
                }
                
                if ($row->producto->icbper == 1) {
                    $array['boleta'][$i]['tiene_icbper'] = 1;
                    $array['boleta'][$i]['cantidad_icbper'] = $array['boleta'][$i]['cantidad_icbper'] + number_format($row->cantidad, 0, ".", "");
                    $array['boleta'][$i]['subtotal_icbper'] = $array['boleta'][$i]['subtotal_icbper'] + $row->cantidad*$empresa->valor_icbper;
                }

                $subtotal = $subtotal + $row->precio_venta_neto;  
                $total = $total + $row->precio_venta_total; 
            }

            $array['boleta'][$i]['subtotal_afecto'] = number_format($array['boleta'][$i]['subtotal_afecto'], 2, ".", "");
            $array['boleta'][$i]['subtotal_exonerado'] = number_format($array['boleta'][$i]['subtotal_exonerado'], 2, ".", "");
            $array['boleta'][$i]['subtotal_inafecto'] = number_format($array['boleta'][$i]['subtotal_inafecto'], 2, ".", "");
            $array['boleta'][$i]['subtotal'] = number_format($subtotal, 2, ".", ""); 
            $array['boleta'][$i]['impuesto'] = number_format($impuesto, 2, ".", "");
            
            $array['boleta'][$i]['total'] = number_format($total, 2, ".", "");

            $i++;
        }
       
        $array['carpeta'] = "resumen";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

        crearResumenXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);
    }

    public function crearResumenNota($id)
    {  

        $resumen = Resumen::where(['id_resumen' => $id , 'estado' => 1])->first();
        $detalle_resumen =  DetalleResumen::with(['nota'])->where(['id_resumen' => $resumen->id_resumen, 'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['tipo'] = $resumen->id_tipo_comprobante; // 2 = BOLETA | 3 = NOTA CREDITO
        $array['comprobante']['fecha'] = $resumen->fecha_referencia;
        $array['resumen']['nombre'] = $resumen->nombre_resumen;
        $array['resumen']['fecha'] = $resumen->fecha_emision;
        $array['resumen']['local'] = $resumen->id_local;
 
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;

        $array['comprobante']['valor_icbper'] = $empresa->valor_icbper;


        $i = 0;
        foreach ($detalle_resumen as $resu) 
        {
            $array['boleta'][$i]['tipo_comprobante'] = $resu->nota->venta->tipo_comprobante->codigo;
            $array['boleta'][$i]['nombre'] = $resu->nota->venta->nombre_comprobante;
            $array['boleta'][$i]['num_doc_cliente'] = $resu->nota->venta->cliente->numero_documento;
            $array['boleta'][$i]['tipo_doc_cliente'] = $resu->nota->venta->cliente->tipo_documento->codigo;

            $array['nota'][$i]['tipo_comprobante'] = $resu->nota->tipo_comprobante->codigo;
            $array['nota'][$i]['nombre'] = $resu->nota->nombre_nota;
            
            $notas = Nota::where('id_nota', $resu->id_nota)->first(); 
            $detalles = DetalleVenta::with(['producto'])->where(['id_venta' => $notas->id_venta, 'estado' => 1])->get();

            $impuesto = 0;
            $subtotal = 0;
            $total = 0;

            $array['boleta'][$i]['subtotal_afecto'] = 0;
            $array['boleta'][$i]['subtotal_exonerado'] = 0;
            $array['boleta'][$i]['subtotal_inafecto'] = 0;

            $array['boleta'][$i]['cantidad_icbper'] = 0;
            $array['boleta'][$i]['subtotal_icbper'] = 0;
            $array['boleta'][$i]['tiene_icbper'] = 0;

            foreach ($detalles as $row) 
            {
                $_total = $row->cantidad*$row->precio_venta;
                $neto = 1+($row->producto->valor_impuesto/100);

                $subtotal = $subtotal + ($_total/$neto);  
                $_impuesto = ($_total - ($_total/$neto));
                $total = $total + $row->precio_venta_total; 

                if ($row->producto->situacion_impuesto == "AFECTO") {
                    $array['boleta'][$i]['subtotal_afecto']  = $array['boleta'][$i]['subtotal_afecto'] + ($_total/$neto);
                    $impuesto = $impuesto + $_impuesto;
                }
                else if ($row->producto->situacion_impuesto == "EXONERADO") {
                    $array['boleta'][$i]['subtotal_exonerado']= $array['boleta'][$i]['subtotal_exonerado'] + ($_total/$neto);
                }
                else if ($row->producto->situacion_impuesto == "INAFECTO") {
                    $array['boleta'][$i]['subtotal_inafecto']  = $array['boleta'][$i]['subtotal_inafecto'] + ($_total/$neto);
                }

                if ($row->producto->icbper == 1) {
                    $array['boleta'][$i]['tiene_icbper'] = 1;
                    $array['boleta'][$i]['cantidad_icbper'] = $array['boleta'][$i]['cantidad_icbper'] + number_format($row->cantidad, 0, ".", "");
                    $array['boleta'][$i]['subtotal_icbper'] = $array['boleta'][$i]['subtotal_icbper'] + $row->cantidad*$empresa->valor_icbper;
                }
            }

            $array['boleta'][$i]['subtotal_afecto'] = number_format($array['boleta'][$i]['subtotal_afecto'], 2, ".", "");
            $array['boleta'][$i]['subtotal_exonerado'] = number_format($array['boleta'][$i]['subtotal_exonerado'], 2, ".", "");
            $array['boleta'][$i]['subtotal_inafecto'] = number_format($array['boleta'][$i]['subtotal_inafecto'], 2, ".", "");

            $array['boleta'][$i]['subtotal'] = number_format($subtotal, 2, ".", ""); 
            $array['boleta'][$i]['impuesto'] = number_format($impuesto, 2, ".", "");
            $array['boleta'][$i]['total'] = number_format($total, 2, ".", "");

            $i++;

        }

        $array['carpeta'] = "resumen";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

        crearResumenNotaXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);

    }



    /*****************************************************************************************************************/
    /* OBTENER CDR DE UN RESUMEN
    /*****************************************************************************************************************/

    public function cdrResumen(Request $request)
    {  
        $resumen = Resumen::find($request->id);
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
       
        $array['resumen']['nombre'] = $resumen->nombre_resumen;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "resumen";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

        $send = consultaTicketResumen($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaResumen($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        //Actualizamos estados
        $resumen->estado_envio    = $estado ; // ACEPTADO | RECHAZADO | NO ENVIADO 
        $resumen->mensaje_envio   = $mensaje;
        $resumen->save();

        $detalles =  DetalleResumen::where(['id_resumen' => $resumen->id_resumen, 'estado' => 1])->get();

        if ($estado == "ACEPTADO" || $estado == "NO ENVIADO") {
            foreach ($detalles as $venta) 
            {
                if ($resumen->id_tipo_comprobante == 2) {
                    $data = Venta::find($venta->id_venta);
                }
                if ($resumen->id_tipo_comprobante == 3) {
                    $data = Nota::find($venta->id_nota);
                }
                $data->estado_envio    = $estado ; // ACEPTADO | NO ENVIADO 
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
        } else {
            foreach ($detalles as $venta) 
            {
                if ($resumen->id_tipo_comprobante == 2) {
                    $data = Venta::find($venta->id_venta);
                }
                if ($resumen->id_tipo_comprobante == 3) {
                    $data = Nota::find($venta->id_nota);
                }
                $data->estado_envio    = "RECHAZADO";
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
        }
        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }

    public function cdrBaja(Request $request)
    {  
        $baja = Baja::find($request->id);
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['resumen']['nombre'] = $baja->nombre_baja;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "bajas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];
      
        $send = consultaTicketResumen($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaResumen($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        //Actualizamos estados
        $baja->estado_envio    = $estado ; // ACEPTADO | RECHAZADO | NO ENVIADO | REINTENTAR
        $baja->mensaje_envio   = $mensaje;
        $baja->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }

    public function cdrFactura(Request $request)
    {  
        $venta = Venta::with(['tipo_comprobante'])->where(['id_venta' => $request->id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo;
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;
        $array['comprobante']['numero'] = $venta->numero_comprobante;
        $array['comprobante']['serie'] = $venta->serie_comprobante;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "comprobantes";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante']."-".$array['comprobante']['nombre'];

        $send = consultaCdrComprobante($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaComprobante($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        $data = Venta::find($venta->id_venta);
        $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
        $data->mensaje_envio   = $mensaje;
        $data->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }

    public function cdrNota(Request $request)
    {  
        $nota = Nota::with('tipo_comprobante')->where(['id_nota' => $request->id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['tipo_comprobante'] = $nota->tipo_comprobante->codigo;
        $array['comprobante']['nombre'] = $nota->nombre_nota;
        $array['comprobante']['numero'] = $nota->numero_nota;
        $array['comprobante']['serie'] = $nota->serie_nota;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "notas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante']."-".$array['comprobante']['nombre'];
    
        $send = consultaCdrComprobante($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaComprobante($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        //Actualizamos estados
        $data = Nota::find($nota->id_nota);
        $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
        $data->mensaje_envio   = $mensaje;
        $data->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }


    /*****************************************************************************************************************/
    /* API REST DE PRODUCTOS
    /*****************************************************************************************************************/

    public function productos()
    {
        $data = [
            'productos' =>  ProductoLocal::select('productos.id_producto', DB::raw("CONCAT(productos.nombre, ' ', COALESCE(productos.descripcion,''), '(S/ ', productos.precio,')') AS nombre"))->join('productos', 'productos.id_producto','=', 'producto_local.id_producto')->where('producto_local.id_local', Auth::guard("usuario")->user()->id_local)->where('producto_local.estado', 1)->where('producto_local.stock', '>', 0)->orderBy('productos.nombre', 'ASC')->limit(50)->get(),
        ];
        return $data;
    } 

    public function buscarProductos($query)
    {
         $data = [
            'productos' => ProductoLocal::select('productos.id_producto', DB::raw("CONCAT(productos.nombre, ' ', COALESCE(productos.descripcion,''), '(S/ ', productos.precio,')') AS nombre"))->join('productos', 'productos.id_producto','=', 'producto_local.id_producto')->where('producto_local.id_local', Auth::guard("usuario")->user()->id_local)->where('productos.nombre', 'LIKE',  '%'.$query.'%')->where('producto_local.estado', 1)->where('producto_local.stock', '>', 0)->limit(50)->get(),
         ];
        return $data;
    } 

    public function igv()
    {
        $data = [
            'igv' =>  Empresa::select('valor_impuesto')->where('id_empresa', 1)->limit(1)->get(),
        ];
        return $data;
    } 


    public function envios()
    {
        header('Access-Control-Allow-Origin: *');
        header('Content-Type: application/json');
        $data = [
            'facturas_aceptadas' => Venta::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 1, 'estado_envio' => 'ACEPTADO', 'estado' => 1])->count(),
            'facturas_rechazadas' => Venta::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 1, 'estado_envio' => 'RECHAZADO', 'estado' => 1])->count(),
            'facturas_no_enviadas' => Venta::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 1, 'estado_envio' => 'NO ENVIADO', 'estado' => 1])->count(),
            'facturas_pendientes' => Venta::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 1, 'estado_envio' => 'REGISTRADO', 'estado' => 1])->count(),

            'notas_aceptadas' => Nota::select('notas.id_nota')->join('ventas', 'ventas.id_venta','=', 'notas.id_venta')->whereRaw('DATEDIFF(CURDATE(),notas.created_at) < 30')->where(['notas.estado_envio' => 'ACEPTADO', 'ventas.id_tipo_comprobante' => 1,'notas.estado' => 1])->count(),
            'notas_rechazadas' => Nota::select('notas.id_nota')->join('ventas', 'ventas.id_venta','=', 'notas.id_venta')->whereRaw('DATEDIFF(CURDATE(),notas.created_at) < 30')->where(['notas.estado_envio' => 'RECHAZADO', 'ventas.id_tipo_comprobante' => 1,'notas.estado' => 1])->count(),
            'notas_no_enviadas' => Nota::select('notas.id_nota')->join('ventas', 'ventas.id_venta','=', 'notas.id_venta')->whereRaw('DATEDIFF(CURDATE(),notas.created_at) < 30')->where(['notas.estado_envio' => 'NO ENVIADO', 'ventas.id_tipo_comprobante' => 1,'notas.estado' => 1])->count(),
            'notas_pendientes' => Nota::select('notas.id_nota')->join('ventas', 'ventas.id_venta','=', 'notas.id_venta')->whereRaw('DATEDIFF(CURDATE(),notas.created_at) < 30')->where(['notas.estado_envio' => 'REGISTRADO', 'ventas.id_tipo_comprobante' => 1,'notas.estado' => 1])->count(),

            'resumenes_boletas_aceptados' => Resumen::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 2, 'estado_envio' => 'ACEPTADO', 'estado' => 1])->count(),
            'resumenes_boletas_rechazados' => Resumen::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 2, 'estado_envio' => 'RECHAZADO', 'estado' => 1])->count(),
            'resumenes_boletas_no_enviados' => Resumen::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 2, 'estado_envio' => 'NO ENVIADO', 'estado' => 1])->count(),
            'resumenes_boletas_pendientes' => Resumen::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 2, 'estado_envio' => 'PENDIENTE', 'estado' => 1])->count(),

            'resumenes_notas_aceptados' => Resumen::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 3, 'estado_envio' => 'ACEPTADO', 'estado' => 1])->count(),
            'resumenes_notas_rechazados' => Resumen::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 3, 'estado_envio' => 'RECHAZADO', 'estado' => 1])->count(),
            'resumenes_notas_no_enviados' => Resumen::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 3, 'estado_envio' => 'NO ENVIADO', 'estado' => 1])->count(),
            'resumenes_notas_pendientes' => Resumen::whereRaw('DATEDIFF(CURDATE(),created_at) < 30')->where(['id_tipo_comprobante' => 3, 'estado_envio' => 'PENDIENTE', 'estado' => 1])->count(),

         ];
        return $data;
    } 


}