<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Delivery;
use App\Models\DetalleDelivery;
use App\Models\Empresa;
use App\Models\Local;
use App\Models\ProductoLocal;
use App\Models\Producto;
use App\Models\Cliente;

class ApiController extends Controller
{
    
    /*****************************************************************************************************************/
    /* API REST DE PRODUCTOS
    /*****************************************************************************************************************/

    public function getLocal()
    {
        $data = Local::where('estado', 1)->limit(1)->get();
        return $data[0];
    }

    public function getEmpresa()
    {
        $data = Empresa::where('estado', 1)->limit(1)->get();
        return $data[0];
    }

    public function productos()
    {
        $data = [
            'productos' =>  ProductoLocal::select('productos.id_producto', DB::raw("CONCAT(productos.nombre, ' ', COALESCE(productos.descripcion,''), ' (S/ ', productos.precio,')') AS nombre"))->join('productos', 'productos.id_producto','=', 'producto_local.id_producto')->where('producto_local.id_local', $this->getLocal()->id_local)->where('producto_local.estado', 1)->where('producto_local.stock', '>', 1000000)->orderBy('productos.nombre', 'ASC')->limit(50)->get(),
        ];
        return $data;
    } 

    public function buscarProductos($query)
    {
         $data = [
            'productos' => ProductoLocal::select('productos.id_producto', DB::raw("CONCAT(productos.nombre, ' ', COALESCE(productos.descripcion,''), ' (S/ ', productos.precio,')') AS nombre"))->join('productos', 'productos.id_producto','=', 'producto_local.id_producto')->where('producto_local.id_local', $this->getLocal()->id_local)->where('productos.nombre', 'LIKE',  '%'.$query.'%')->where('producto_local.estado', 1)->where('producto_local.stock', '>', 1000000)->limit(50)->get(),
         ];
        return $data;
    } 

    public function getById(Request $request)
    {
        if ($request->ajax())
        {
            $res = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $request->id_producto)->where('id_local', $this->getLocal()->id_local)->where('estado', 1)->first();

            return response()->json($res);  
        }
    }

    public function getByNombre(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->search))
            {
                $prod =  Producto::with(['tipo_presentacion'])->where(function ($query) {
                        $query->where('estado', '=', 1);
                    })->where(function ($query)  use ($request) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('descripcion', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('precio', 'LIKE',  '%'.$request->search.'%');
                    })->limit(50)->get();

                if ($prod)
                { 
                    foreach ($prod as $data) {
                        $dato = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $data->id_producto)->where('id_local', $this->getLocal()->id_local)->where('estado', 1)->where('stock', '>', 1000000)->first();
                        if ( !is_null($dato) ) {
                            $res[] = $dato;
                        }
                    }
                    
                }
            }
            return response()->json($res); 
        }
    }


    public function getProductos(Request $request)
    {
        if ($request->ajax())
        {
            $data = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_local', $this->getLocal()->id_local)->where('estado', 1)->where('stock', '>', 1000000)->limit(50)->get();
            return response()->json($data); 
        }
    }

    public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $id_local = $this->getLocal()->id_local;
            $request->request->add(['id_local' => $id_local]);
            $request->request->add(['total' => $request->total_venta]);
            $request->request->add(['fecha_emision' => date('Y-m-d')]);
            $res = Delivery::create($request->all());

            if (!is_null($request->nombre) && !is_null($request->numero_documento) && (Cliente::where('numero_documento', $request->numero_documento)->count() == 0)) {
                if (strlen($request->numero_documento) == 11) {
                    $id_tipo_documento = 1;
                } else{
                    $id_tipo_documento = 2;
                }
                $cliente= [
                    'id_tipo_documento' => $id_tipo_documento, 
                    'nombre' => $request->nombre, 
                    'numero_documento' => $request->numero_documento, 
                    'direccion' => $request->direccion, 
                    'telefono' => $request->telefono, 
                    'email' => $request->email, 
                ];

                Cliente::create($cliente);
            }
            
            if ($res) 
            {
                for( $i = 0; $i < count($request->id_producto); $i++)
                {
                    $detalle= [
                        'id_delivery' => $res->id_delivery, 
                        'id_producto' => $request->id_producto[$i], 
                        'cantidad' => $request->cantidad[$i], 
                        'precio' => $request->precio_venta[$i], 
                        'descuento' => $request->descuento[$i], 
                        'subtotal' => $request->subtotal[$i], 
                    ];

                    DetalleDelivery::create($detalle);
                }  
            }
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 

        }
    }

    public function getDniByApi(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->numero_documento))
            {
                //$url = 'http://aplicaciones007.jne.gob.pe/srop_publico/Consulta/Afiliado/GetNombresCiudadano?DNI=';
                $url = 'http://api.soft.pe/personas/buscar.php?dni=';

                if (!@file_get_contents($url) === false)
                //if (!@file_get_contents($url.$request->numero_documento) === false) 
                {
                    /*$consulta = file_get_contents($url.$request->numero_documento);
                    $partes = explode("|", $consulta);
                    $res = [
                        'nombre' => $partes[2]." ".$partes[0]." ".$partes[1]
                    ];*/

                    $consulta = file_get_contents($url.$request->numero_documento);
                    $output= json_decode($consulta, true);
                    if( $output['success'] == true )
                    {
                        $res = [
                            'nombre' => $output['result']['nombre']." ".$output['result']['paterno']." ".$output['result']['materno'],
                        ];
                    }
                }
                else {
                    $res = Cliente::where('numero_documento', $request->numero_documento)->first();
                }      
            }
            return response()->json($res);  
        }
    }

    public function getRucByApi(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->numero_documento))
            {
                //$url = 'https://api.sunat.cloud/ruc/';
                $url = 'http://api.soft.pe/sunat/buscar.php?ruc=';
                
                if (!@file_get_contents($url) === false) 
                {     
                    $consulta = file_get_contents($url.$request->numero_documento);
                    $output= json_decode($consulta, true);
                    if($output['success'] == true)
                    {
                        $res = [
                            'nombre' => $output['result']['razon_social'],
                            'direccion' => $output['result']['direccion'],
                            //'direccion' => $output['domicilio_fiscal'],
                        ];
                    }
                }
                else {
                    $res = Cliente::where('numero_documento', $request->numero_documento)->first();
                } 

            }
            return response()->json($res);  
        }
    }


}