<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">COMPRAR PRODUCTOS PARA ALMACÉN</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off"> 
                
                <!-- start tab 1 -->
                <div class="ui tab active" data-tab="one">

                    <div class="three fields">
                        <div class="three wide field">
                            <div class="ui fluid large white label">Almacén de Destino</div>
                        </div>
                        <div class="eleven wide field">
                            <select class="ui fluid small input dropdown" name="id_local">
                                <option value="<?php echo e(Auth::guard("usuario")->user()->id_local); ?>"> <?php echo e(Auth::guard('usuario')->user()->local->nombre); ?> (<?php echo e(ucwords(mb_strtolower(Auth::guard('usuario')->user()->local->direccion ))); ?>)</option>  
                            </select>  
                        </div>
                    </div>

                    <div class="three fields">
                        <div class="three wide field">
                            <div class="ui fluid large white label">Proveedor</div>
                        </div>
                        <div class="eleven wide field">
                            <select class="ui small search selection dropdown" name="id_proveedor">
                            <option value="">Seleccione</option>
                            <?php $__currentLoopData = $proveedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                               <option value="<?php echo e($data->id_proveedor); ?>"> <?php echo e($data->nombre); ?> (<?php echo e(ucwords(mb_strtolower($data->numero_documento ))); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                        </select> 
                        </div>
                        <div class="two wide field">
                            <div class="ui fluid small green button btn_nuevo_proveedor" title="Clic para agregar nuevo"><i class="plus icon"></i>NUEVO</div>
                        </div>
                    </div>

                    <div class="four fields">
                        <div class="three wide field">
                            <div class="ui fluid large white label">Tipo Comprobante</div>
                        </div>
                        <div class="field">
                            <select class="ui fluid small input dropdown" name="tipo_comprobante">
                                <option value="">Seleccione</option>
                                <option value="Factura">Factura</option>
                                <option value="Boleta">Boleta</option>
                                <option value="Recibo">Recibo</option>
                                <option value="Otros">Otros</option>
                            </select> 
                        </div>
                        <div class="three wide field">
                            <div class="ui fluid large white label">Fecha de Compra</div>
                        </div>
                        <div class="field">
                            <div class="ui small input">
                                <input type="text" class="fecha hasDate" name="fecha_compra" >
                            </div> 
                        </div>
                    </div>

                    <div class="five fields">
                        <div class="three wide field">
                            <div class="ui fluid large white label">N° Comprobante</div>
                        </div>
                        <div class="four wide field">
                            <div class="ui small input">
                                <input type="text" placeholder="F001-001" name="numero_comprobante" oninput="$.upperCase(this)">
                            </div> 
                        </div>
                        <div class="three wide field">
                            <div class="ui fluid large white label">Tipo de Compra</div>
                        </div>
                        <div class="four wide field">
                            <select class="ui fluid small input dropdown" name="tipo_compra">
                                <option value="CONTADO">Al Contado</option>
                                <option value="CREDITO">Al Crédito</option>
                            </select> 
                        </div>
                        <div class="two wide field" id="fecha_pago" style="visibility: hidden;">
                            <div class="ui small input">
                                <input type="text" class="fecha_fut" name="fecha_pago" placeholder="Fecha Pago">
                            </div> 
                        </div>
                    </div>

                    <div class="form_footer">
                        <div class="ui right floated default button tab_two">SIGUIENTE<i class="arrow right icon"></i></div>
                    </div>
                </div>
                <!-- end tab 1 -->

                <!-- start tab 2 -->
                <div class="ui tab" data-tab="two">

                    
                    <div class="four fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Buscar Producto</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui fluid small purple button btn_buscar_producto" title="Clic para buscar"><i class="search icon"></i>BUSCAR PRODUCTO</div>
                        </div>
                        <div class="four wide field">
                            <div class="ui fluid large white label">Registrar Nuevo Producto</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui fluid small green button btn_nuevo_producto" title="Clic para agregar nuevo"><i class="plus icon"></i>REGISTRAR NUEVO</div>
                        </div>
                    </div>


                    <div class="four fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Moneda</div>
                        </div>
                        <div class="three wide field">
                            <select class="ui fluid small input dropdown" id="moneda">
                                <option value="SOLES">SOLES</option>
                                <option value="DOLARES">DOLARES</option>
                                
                            </select> 
                        </div>
                        <div class="four wide field tipo_cambio" style="visibility: hidden;">
                            <div class="ui fluid large white label">Tipo de Cambio</div>
                        </div>
                        <div class="three wide field tipo_cambio" style="visibility: hidden;">
                            <div class="ui small input">
                                <input type="text" id="valor_cambio" name="valor_cambio" value="1.00">
                            </div> 
                        </div>
                    </div>

                    <div class="four fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Observacion</div>
                        </div>
                        <div class="ten wide field">
                            <div class="ui small input ">
                                <input type="text" name="observacion" maxlength="800" oninput="$.upperCase(this)">
                            </div>
                        </div>
                    </div>

                    <div class="ui hidden divider"></div>
                    <div class="form_footer">
                        <div class="ui left floated default button tab_one"><i class="arrow left icon"></i>REGRESAR</div>
                        
                    </div>

                    <div class="ui hidden divider"></div>

                    <table class="ui celled table">
                        <thead>
                            <tr>
                                <th class="center aligned">Producto</th>
                                <th class="center aligned" data-tooltip="Cantidad comprada" data-position="top center" data-inverted="">Cantidad</th>
                                <th class="center aligned" data-tooltip="Precio de compra por unidad" data-position="top center" data-inverted="">Precio de Compra</th>
                                <th class="center aligned">Subtotal</th>
                                <th class="center aligned">Acción</th>
                            </tr>
                        </thead>
                        <tbody id="tbody"></tbody>
                    </table>    


                    <div class="form_footer">

                        <div class="ui labeled small input">
                            <label class="ui brown label">TOTAL</label>
                            <input type="text" name="total_compra" id="total_compra" size="5" readonly style="width: 0%">
                        </div> 
                        
                        <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR COMPRA</div>
                    </div>
                </div>
                <div id="inputs"></div>
                <!-- end tab 2 -->
            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="shopping cart icon"></i>Registrar Productos</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar estos productos en el sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start nuevo proveedor modal -->
    <div class="ui standard small modal" id="nuevo_proveedor_modal">
        <div class="header">Registrar Nuevo Proveedor</div>
        <div class="content">
            <div class="ui disabled inverted dimmer" id="loader_proveedor">
                <div class="ui text loader">Procesando...</div>
            </div>
            <form class="ui form" id="frmNevoProveedor" autocomplete="off">
                <div class="field">
                    <div class="field">
                        <label>Nombre / Razon Social</label>
                        <div class="ui small input ">
                          <input type="text" name="nombre" maxlength="200" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>
                
                <div class="two fields">
                    <div class="field">
                        <label>Tipo de Documento</label>
                        <select class="ui small input dropdown" name="id_tipo_documento">
                            <option value="">Seleccione</option>
                             <?php $__currentLoopData = $tipo_documento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tipo->id_tipo_documento); ?>"><?php echo e($tipo->nombre); ?></option>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                    </div>
                    <div class="field">
                        <label>Numero de Documento</label>
                        <div class="ui small input ">
                          <input type="text" name="numero_documento" maxlength="11">
                        </div>
                    </div>
                </div> 

                <div class="two fields">
                    <div class="field">
                        <label>Direccion</label>
                        <div class="ui small input ">
                          <input type="text" name="direccion" maxlength="200" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="field">
                        <label>Telefono</label>
                        <div class="ui small input ">
                          <input type="text" name="telefono"  maxlength="15">
                        </div>
                    </div>
                </div>
                <div class="two fields">
                    <div class="field">
                        <label>Email</label>
                        <div class="ui small input ">
                          <input type="text" name="email" maxlength="50">
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_registrar_proveedor"><i class="check icon"></i>REGISTRAR</div>
        </div>
    </div>
    <!--end nuevo proveedor  modal -->

    <!--start nuevo producto modal -->
    <div class="ui modal" id="nuevo_producto_modal">
        <div class="header">Registrar Nuevo Producto</div>     
        <div class="scrolling content">
            <div class="ui disabled inverted dimmer" id="loader_producto">
                <div class="ui text loader">Procesando...</div>
            </div>
            <form class="ui form" id="frmNuevoProducto" autocomplete="off">

                <div class="field">
                    <div class="field">
                        <label>Nombre del producto</label>
                        <div class="ui small input ">
                          <input type="text" name="nombre"  maxlength="800" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div> 
                
                <div class="two fields">
                    <div class="field">
                        <label>Marca del producto</label>
                        <div class="ui small input ">
                          <input type="text" name="descripcion" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="field">
                        <label>Código de Barras</label>
                        <div class="ui small input ">
                          <input type="text" name="codigo_barras"  maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>

                <div class="two fields">
                    
                    <div class="six wide field">
                        <label>Precio de Venta por UNIDAD</label>
                        <div class="ui labeled small input">
                            <input type="text" name="precio" maxlength="11">
                        </div>  
                    </div>

                    <div class="two wide field">
                        <label> &nbsp;</label>
                        <select class="ui fluid small input dropdown" name="tipo_precio">
                            <option value="1"> S/ </option>
                            <option value="2"> %  </option>
                        </select>    
                    </div>

                    
                    <div class="three wide field">
                        <label>Precio de venta por</label>
                        <div class="ui small input">
                            <input type="text" name="precio_mayorista" maxlength="11">
                        </div>  
                    </div>

                     <div class="two wide field">
                        <label> MAYOR</label>
                        <select class="ui fluid small input dropdown" name="tipo_precio_2">
                            <option value="1"> S/ </option>
                            <option value="2"> %  </option>
                        </select>    
                    </div>

                    <div class="three wide field">
                        <label>Precio de Compra</label>
                        <div class="ui labeled small input">
                            <label class="ui label">S/</label>
                            <input type="text" name="precio_compra" maxlength="11">
                        </div>  
                    </div>

                    

                </div> 

                <div class="two fields">
                    <div class="field">
                        <label>Tipo de Presentación</label>
                        <select class="ui small search selection dropdown" name="id_tipo_presentacion">
                            <?php $__currentLoopData = $tipo_presentacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tipo->id_tipo_presentacion); ?>"> <?php echo e($tipo->nombre); ?> </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                    </div>
                    <div class="field">
                        <label>Unidad de Medida</label>
                        <select class="ui small search selection dropdown" name="id_unidad_medida">
                            <?php $__currentLoopData = $unidad_medida; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($unidad->id_unidad_medida); ?>"><?php echo e($unidad->nombre); ?> (<?php echo e($unidad->abreviatura); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                    </div>
                </div>

                <div class="two fields">
                    <div class="field">
                        <label>Situacion de Impuesto</label>
                        <select class="ui small selection dropdown" name="situacion_impuesto">
                            <option value="AFECTO">Afecto</option>
                            <option value="INAFECTO">Inafecto</option>
                            <option value="EXONERADO">Exonerado</option>
                        </select>  
                    </div>

                    <div class="field">
                        <label>Tipo de Producto</label>
                        <select class="ui small input dropdown" name="tipo_producto">
                            <option value="Generico">Generico</option>
                            <option value="Comercial">Comercial</option>
                        </select>  
                    </div> 
                </div> 


                <div class="two fields">
                    <div class="field">
                        <label>Tipo de Impuesto</label>
                        <select class="ui small selection dropdown" name="tipo_impuesto">
                            <option value="IGV">IGV</option>
                            
                        </select>  
                    </div>

                    <div class="field">
                        <label>Valor de Impuesto</label>
                        <div class="ui right labeled small input">
                            <input type="text" name="valor_impuesto" id="valor_impuesto" value="<?php echo e($empresa->valor_impuesto); ?>" maxlength="8" readonly="">
                            <label class="ui label">%</label>
                        </div>  
                    </div> 

                </div> 


                <div class="two fields">
                    <div class="field">
                        <label>Fecha de Vencimiento</label>
                        <div class="ui small input">
                            <input type="text" class="fecha" name="fecha_vencimiento">
                        </div>   
                    </div>

                    <div class="field">
                        <label>Lote / Serie</label>
                        <div class="ui small input">
                            <input type="text" name="lote" maxlength="800" oninput="$.upperCase(this)">
                        </div>  
                    </div> 

                </div> 
 
            </form>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_registrar_producto"><i class="check icon"></i>REGISTRAR</div>
        </div>
    </div>
    <!--end nuevo producto  modal --> 

    <!--start buscar producto modal -->
    <div class="ui standard large modal" id="buscar_producto_modal">
        <div class="header">Buscar Productos</div>
        <div class="scrolling content">
            <div class="ui disabled inverted dimmer" id="loader_busqueda">
                <div class="ui text loader">Procesando...</div>
            </div>
            <div class="ui action small input"  autocomplete="off">
                <input type="text" id="buscar_producto" name="buscar_producto" placeholder="Producto a buscar...">
                <div class="ui icon button" id="btn_buscar_prod" title="Clic para buscar"><i class="search icon"></i></div>
            </div> 
            <table class="ui celled striped table" id="tabla_productos">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Cod Barras</th>
                        <th class="head_table">Producto</th>
                        <th class="head_table">Marca</th>
                        <th class="head_table">Presentacion</th>
                        <th class="head_table">Precio Venta S/</th>
                        <th class="head_table">Vencimiento</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody_productos">
                   <?php /**/ $i = 1/**/ ?>
                    <?php $__currentLoopData = $productos->sortBy('producto.nombre'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($row->id_producto); ?>">
                        <td><?php echo e($i); ?></td>
                        <td><?php echo e($row->producto->codigo_barras); ?></td>
                        <td><?php echo e($row->producto->nombre); ?> </td>
                        <td><?php echo e($row->producto->descripcion); ?></td>
                        <td><?php echo e($row->producto->tipo_presentacion->nombre); ?></td>
                        <td><?php echo e($row->producto->precio); ?></td>
                        <td><?php echo e(!is_null($row->producto->fecha_vencimiento) ? $row->producto->fecha_vencimiento : "Sin fecha"); ?></td>
                        
                        <td>                            
                            <div class="ui mini vertical animated positive button btn_seleccionar_producto" title="Seleccionar este producto" data-id="<?php echo e($row->id_producto); ?>" >
                                <div class="hidden content">Elegir</div>
                                <div class="visible content"><i class="check icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="actions" >
            <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar producto modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/compra/nuevo.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>