@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fifteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">TRASLADAR PRODUCTOS</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">

                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Local de partida</div>
                        </div>
                        <div class="nine wide field">
                            <select class="ui fluid small input dropdown" name="id_local_origen">
                                <option value="">Seleccione </option>
                                @foreach($locales as $local)
                                 <option value="{{ $local->id_local }}"> {{ $local->nombre }} ({{ $local->tipo_local->nombre }}) - {{ ucwords(mb_strtolower($local->direccion ))}} </option>
                                @endforeach  
                            </select>  
                        </div>
                    </div>

                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Local de llegada</div>
                        </div>
                        <div class="nine wide field">
                            <select class="ui fluid small input dropdown" name="id_local_destino">
                                <option value="">Seleccione </option>
                                @foreach($locales as $local)
                                 <option value="{{ $local->id_local }}"> {{ $local->nombre }} ({{ $local->tipo_local->nombre }}) - {{ ucwords(mb_strtolower($local->direccion ))}} </option>
                                @endforeach  
                            </select>  
                        </div>
                    </div>

            
                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Motivo de traslado</div>
                        </div>
                        <div class="nine wide field">
                            <div class="ui small input ">
                              <input type="text" name="descripcion"  maxlength="100" oninput="$.upperCase(this)">
                            </div>
                        </div>
                    </div>
                    

                    <div class="four fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Flete</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" name="flete" value="0.00" maxlength="11">
                            </div> 
                        </div>
                    </div>
                    <br>

                    <div class="three fields">
                        <div class="four wide field"></div>
                        <div class="nine wide field">
                            <div class="ui fluid small green button btn_buscar_producto" title="Clic para buscar"><i class="search icon"></i>BUSCAR PRODUCTOS PARA TRASLADAR</div>
                        </div>
                    </div>
                    <br><br>
                    <table class="ui celled table">
                        <thead>
                            <tr>
                                <th class="center aligned" data-tooltip="Codigo de Barras" data-position="top center" data-inverted="">Cod. Barras</th>
                                <th class="center aligned">Nombre</th>
                                <th class="center aligned">Presentacion</th>
                                <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">U. Med.</th>
                                <th class="center aligned">Precio S/</th>
                                <th class="center aligned" data-tooltip="Cantidad a trasladar" data-position="top center" data-inverted="">Cantidad</th>
                                <th class="center aligned">Acción</th>
                            </tr>
                        </thead>
                        <tbody id="tbody"></tbody>
                    </table>

                    <div class="form_footer">
                        <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR</div>
                    </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="check circle icon"></i>Registrar Información</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar esta información en el sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start buscar producto modal -->
    <div class="ui standard large modal" id="buscar_producto_modal">
        <div class="header">Buscar Productos</div>
        <div class="scrolling content">

            <div class="ui disabled inverted dimmer" id="loader_producto">
                <div class="ui text loader">Cargando...</div>
            </div>

            <div class="ui disabled inverted dimmer" id="loader_busqueda">
                <div class="ui text loader">Procesando...</div>
            </div>
            <div class="ui action small input"  autocomplete="off">
                <input type="text" id="buscar_producto" name="buscar_producto" placeholder="Producto a buscar...">
                <div class="ui icon button" id="btn_buscar_prod" title="Clic para buscar"><i class="search icon"></i></div>
            </div> 

            <table class="ui celled striped table" id="tabla_productos">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Cod Barras</th>
                        <th class="head_table">Producto</th>
                        <th class="head_table">Presentacion</th>
                        <th class="head_table">U. Med</th>
                        <th class="head_table">Precio S/</th>
                        <th class="head_table">Stock</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody_productos">
                   <?php /**/ $i = 1/**/ ?>
                    @foreach ($producto->sortBy('producto.nombre') as $row)
                    <tr data-table="{{ $row->id_producto }}">
                        <td>{{ $i }}</td>
                        <td>{{ $row->producto->codigo_barras }}</td>
                        <td>{{ $row->producto->nombre }} {{ $row->producto->descripcion }}</td>
                        <td>{{ $row->producto->tipo_presentacion->nombre }}</td>
                        <td>{{ $row->producto->unidad_medida->nombre }}</td>
                        <td>{{ $row->producto->precio }}</td>
                        <td>{{ $row->stock > 1000000 ? number_format(($row->stock - 1000000),2) :  "0" }}</td>
                        
                        <td>                            
                            <div class="ui mini vertical animated positive button btn_seleccionar_producto" title="Seleccionar este producto" data-id="{{ $row->id_producto }}" data-stock="{{ $row->stock }}" data-precio="{{ $row->producto->precio }}">
                                <div class="hidden content">Elegir</div>
                                <div class="visible content"><i class="check icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
            </table>


            
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar producto modal -->
    

    
@stop

@section('scripts')
    <script src="{{ asset('js/traslado/nuevo.js') }}"></script>
@stop


