@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE GUIA DE REMISION ELECTRONICA</h4>

            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que emitió la guia :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se emitió la guia :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet four wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  twelve wide computer column"><a href="{{ url('cliente/editar/'.$data->venta->cliente->id_cliente) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($data->venta->cliente->nombre)) }}</a></div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">{{ $data->venta->cliente->tipo_documento->nombre }} del Cliente :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->venta->cliente->numero_documento }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">N° Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><a href="{{ url('venta/detalles/'.$data->id_venta) }}" title="Clic para ver informacion">{{ $data->venta->nombre_comprobante }}</a></div>
                    </div>
                    @if($data->estado_envio == "REGISTRADO")
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Mensaje de envio a SUNAT :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">PENDIENTE - El comprobante se encuentra pendiente de envio a la SUNAT</div>                    
                    </div>
                    @else
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Mensaje de envio a SUNAT :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">{{ ($data->estado_envio) }} - {{ $data->mensaje_envio }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Envio:</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">{{ ($data->updated_at) }}</div>
                    </div>
                    @endif
                   
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  four wide computer column message_header">N° Guia de Remision:</div>
                        <div class="sixteen wide mobile ten wide tablet  twelve wide computer column">{{ $data->nombre_guia }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  four wide computer column message_header">Direccion de Partida:</div>
                        <div class="sixteen wide mobile ten wide tablet  twelve wide computer column">{{ ucwords(mb_strtolower($data->punto_partida)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  four wide computer column message_header">Direccion de Llegada :</div>
                        <div class="sixteen wide mobile ten wide tablet  twelve wide computer column">{{ ucwords(mb_strtolower($data->punto_llegada)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  four wide computer column message_header">Empresa de Transporte :</div>
                        <div class="sixteen wide mobile ten wide tablet  twelve wide computer column">{{ ucwords(mb_strtolower($data->nombre_transportista)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">RUC Empresa de Transporte :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->documento_transportista }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">DNI Conductor :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->licencia }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Placa del Vechiculo :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->marca_placa }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Traslado :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_traslado }}</div>
                    </div>
                </div>
            </div>
            

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Presentacion del producto" data-position="top center" data-inverted="">Presentacion</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">Unidad de Medida</th>
                        <th class="center aligned" data-tooltip="Cantidad vendida" data-position="top center" data-inverted="">Cantidad</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    @foreach ($detalle_venta as $venta)
                    <tr data-table="{{ $venta->id_detalle_venta }}">
                        <td><a href="{{ url('producto/editar/'.$venta->id_producto) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($venta->producto->nombre)) }} {{ $venta->producto->descripcion}}</a></td>
                        <td>{{ $venta->producto->tipo_presentacion->nombre }}</td>
                        <td>{{ $venta->producto->unidad_medida->nombre }}</td>
                        <td>{{ $venta->cantidad }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>

                @if($data->estado_envio != "ACEPTADO")
                <div class="ui small right floated red button btn_reenviar" data-id="{{$data->id_guia_remision}}"><i class="sync alternate icon"></i>Reenviar</div>
                @endif    

                @if( $data->estado_envio == "ACEPTADO" || $data->estado_envio == "RECHAZADO")
                <a class="ui small right floated blue button btn_cdr" href="{{ url('../sunat/cdr/guias/R-'.$empresa->ruc.'-'.$data->tipo_comprobante->codigo.'-'.$data->nombre_guia.'.xml') }}" target="_blank"><i class="download icon"></i>Descargar CDR</a>
                @endif
                <a class="ui small right floated green button btn_cdr" href="{{ url('../sunat/xml/guias/'.$empresa->ruc.'-'.$data->tipo_comprobante->codigo.'-'.$data->nombre_guia.'.xml') }}" target="_blank"><i class="download icon"></i>Descargar XML</a>

                {{-- <div class="ui small right floated red button btn_anular" data-id="{{ $data->id_guia_remision }}"><i class="times icon"></i>Anular</div> --}}

            </div>  

        </div>
    </div>

    <!--start delete modal -->
    <div class="ui small basic modal" id="delete_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Eliminar Registro</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere eliminar este registro del sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para eliminar"> <i class="checkmark icon"></i>Eliminar</div>
        </div>
    </div>
    <!--end delete modal -->
 
@stop

@section('scripts')
    <script src="{{ asset('js/guia/detalles.js') }}"></script>
@stop


