@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE GUIA DE REMISION</h4>

            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que emitió la guia :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se emitió la guia :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Nombre de Destinatario :</div>
                        @if($data->id_venta != null)
                            <div class="sixteen wide mobile eight wide tablet four wide computer column"><a href="{{ url('cliente/editar/'.$data->venta->cliente->id_cliente) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($data->venta->cliente->nombre)) }}</a></div>
                        @else
                            <div class="sixteen wide mobile eight wide tablet four wide computer column"><a href="{{ url('cliente/editar/'.$data->cliente->id_cliente) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($data->cliente->nombre)) }}</a></div>
                        @endif

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Nº Documento del Destinatario :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->id_venta != null ? $data->venta->cliente->numero_documento : $data->cliente->numero_documento }}</div>
                    </div>

                    {{-- <div class="row" style="padding-bottom: 0px !important">

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">N° Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><a href="{{ url('venta/detalles/'.$data->id_venta) }}" title="Clic para ver informacion">{{ $data->venta->nombre_comprobante }}</a></div> 
                    </div> --}}

                   
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">


                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">N° Guia de Remision:</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->nombre_guia }}</div>
                        @if($data->id_venta != null)
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Nº de Boleta o Factura</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><a href="{{ url('venta/detalles/'.$data->id_venta) }}" title="Clic para ver informacion">{{ $data->venta->nombre_comprobante }}</a></div>
                        @endif
                    </div>

                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  four wide computer column message_header">Direccion de Partida:</div>
                        <div class="sixteen wide mobile ten wide tablet  twelve wide computer column">{{ ucwords(mb_strtolower($data->punto_partida)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  four wide computer column message_header">Direccion de Llegada :</div>
                        <div class="sixteen wide mobile ten wide tablet  twelve wide computer column">{{ ucwords(mb_strtolower($data->punto_llegada)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  four wide computer column message_header">Empresa de Transporte :</div>
                        <div class="sixteen wide mobile ten wide tablet  twelve wide computer column">{{ ucwords(mb_strtolower($data->nombre_transportista)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">RUC Empresa de Transporte :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->documento_transportista }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">DNI Conductor :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->licencia }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Placa del Vechiculo :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->marca_placa }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Traslado :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_traslado }}</div>
                    </div>
                </div>
            </div>
            

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Presentacion del producto" data-position="top center" data-inverted="">Presentacion</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">Unidad de Medida</th>
                        <th class="center aligned" data-tooltip="Cantidad vendida" data-position="top center" data-inverted="">Cantidad</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    @if($data->id_venta != null)

                        @foreach ($detalle_venta as $venta)
                        <tr data-table="{{ $venta->id_detalle_venta }}">
                            <td><a href="{{ url('producto/editar/'.$venta->id_producto) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($venta->producto->nombre)) }} {{ $venta->producto->descripcion}}</a></td>
                            <td>{{ $venta->producto->tipo_presentacion->nombre }}</td>
                            <td>{{ $venta->producto->unidad_medida->nombre }}</td>
                            <td>{{ $venta->cantidad }}</td>
                        </tr>
                        @endforeach
                    @else
                        @foreach ($detalle_guia as $data)
                        <tr data-table="{{ $data->id_detalle_guia_remision }}">
                            <td><a href="{{ url('producto/editar/'.$data->id_producto) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($data->producto->nombre)) }} {{ $data->producto->descripcion}}</a></td>
                            <td>{{ $data->producto->tipo_presentacion->nombre }}</td>
                            <td>{{ $data->producto->unidad_medida->nombre }}</td>
                            <td>{{ $data->cantidad }}</td>
                        </tr>
                        @endforeach

                    @endif

                </tbody> 
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>



                {{-- <div class="ui small right floated red button btn_anular" data-id="{{ $data->id_guia_remision }}"><i class="times icon"></i>Anular</div> --}}

                @if($data->id_venta != null)
                <a class="ui small right floated orange button" href="{{ url('guia/nuevo/'.$data->id_venta) }}" title="Emitir el mismo comprobante en otra guia de remision"><i class="paper plane icon"></i>Emitir de Nuevo</a>
                @endif

                <div class="ui small right floated purple button btn_imprimir" data-id="{{ $data->id_guia_remision }}"><i class="print icon"></i>Imprimir Guia A4</div>
                
            </div>  

        </div>
    </div>

    <!--start delete modal -->
    <div class="ui small basic modal" id="delete_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Eliminar Registro</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere eliminar este registro del sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para eliminar"> <i class="checkmark icon"></i>Eliminar</div>
        </div>
    </div>
    <!--end delete modal -->
 
@stop

@section('scripts')
    <script src="{{ asset('js/guia/detalles.js') }}"></script>
@stop


