@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRO DE PEDIDOS POR DELIVERY</h4>

           <div class="ui equal width grid">
                <div class="row">
                    <div class="column">
                        <form id="frmBuscar" autocomplete="off" method="GET" action="{{ url('delivery/buscar') }}" >
                            <div class="ui action small input" >
                                  <input type="text" placeholder="Buscar..." name="search">
                                  <button type="submit" class="ui icon button " title="Clic para buscar"><i class="search icon"></i></button>
                            </div>
                        </form>
                    </div>
                    <div class="column export_files" style="text-align: right">
                        <select class="ui small input dropdown" name="estado_envio">
                            <option value="">Seleccione</option>
                            <option value="TODOS">TODOS</option>
                            <option value="0">PENDIENTES</option>
                            <option value="1">ATENDIDOS</option>
                            <option value="2">CANCELADOS</option>
                        </select>  
                    </div>
                </div>
            </div> 

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Delivery</th>
                        <th class="head_table">Cliente</th>
                        <th class="head_table">DNI / RUC</th>
                        <th class="head_table">Fecha Pedido</th>
                        <th class="head_table">Monto S/</th>
                        <th class="head_table">Estado</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $delivery)
                    <tr data-table="{{ $delivery->id_delivery }}">
                        <td>{{ $i }}</td>
                         <td>PEDIDO N° {{ $delivery->id_delivery }}</td>
                        <td>{{ $delivery->nombre }}</td>
                        <td>{{ $delivery->numero_documento }}</td>
                       
                        <td>{{ $delivery->fecha_emision }}</td>
                        <td>{{ $delivery->total}}</td>
                        <td>
                            @if($delivery->estado_delivery == "ATENDIDO")
                                <div class="ui green label">{{ $delivery->estado_delivery }}</div>
                            @elseif ($delivery->estado_delivery == "PENDIENTE")
                                <div class="ui yellow label">{{ $delivery->estado_delivery }}</div>
                            @elseif ($delivery->estado_delivery == "CANCELADO")
                                <div class="ui red label">{{ $delivery->estado_delivery }}</div>
                            @endif
                        </td>
                        <td>                            
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('delivery/detalles/'.$delivery->id_delivery) }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="8">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop

@section('scripts')
    <script src="{{ asset('js/delivery/listar.js') }}"></script>
@stop

