<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$option = $_GET['tipo_deuda'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];


	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($option == '1') {

		$consulta = 'SELECT c.nombre AS "Titular", c.numero_documento AS "NUM", DATE_FORMAT(fecha_venta, "%d-%m-%Y" ) AS "Fecha de Emision", nombre_comprobante AS "Comprobante", t.nombre AS "Tipo", total_venta AS "Monto S/", tipo_pago , (SELECT SUM(monto) FROM detalle_credito WHERE detalle_credito.id_venta = v.id_venta ) as pagado , 0 as adelanto FROM ventas v INNER JOIN clientes c ON v.id_cliente = c.id_cliente INNER JOIN tipo_comprobante t ON v.id_tipo_comprobante = t.id_tipo_comprobante WHERE (v.created_at >= "'.$fecha1.' 00:00:00" AND v.created_at <= "'.$fecha2.' 23:59:59") and v.id_nota is null and fecha_pago <> "null"  AND tipo_pago = "CREDITO"  AND id_local= "'.$id_local.'" ';	
	}
	else {
		$consulta = 'SELECT p.adelanto, p.nombre AS "Titular", p.numero_documento AS "NUM", DATE_FORMAT(fecha_emision, "%d-%m-%Y" ) AS "Fecha de Emision", CONCAT("PEDIDO N° " , id_proforma) AS "Comprobante", p.tipo AS "Tipo", total AS "Monto S/", tipo , (SELECT SUM(monto) FROM detalle_credito WHERE detalle_credito.id_proforma = p.id_proforma ) as pagado FROM proformas p  WHERE (p.created_at >= "'.$fecha1.' 00:00:00" AND p.created_at <= "'.$fecha2.' 23:59:59") and adelanto <> "null"  AND tipo = "PEDIDO" AND p.estado = 1 AND id_local= "'.$id_local.'" ';	
	}
	

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de VENTAS REALIZADAS")
									 ->setSubject("Reporte de VENTAS REALIZADAS")
									 ->setDescription("Reporte de VENTAS REALIZADAS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:I1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE DEUDORES')
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'CLIENTE')
		            ->setCellValue('C2', 'RUC / DNI')
					->setCellValue('D2', 'FECHA DE REGISTRO')
					->setCellValue('E2', 'N° COMPROBANTE')
					->setCellValue('F2', 'TIPO COMPROBANTE')
					->setCellValue('G2', 'CREDITO INICIAL S/')
					->setCellValue('H2', 'LETRAS PAGADAS S/')
					->setCellValue('I2', 'DEUDA ACTUAL S/');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:I2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {

			if ($fila['Monto S/'] - ($fila['adelanto'] + $fila['pagado']) > 0.01) {
				$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['Titular']))
			    ->setCellValue('C'.$i, $fila['NUM'])
			    ->setCellValue('D'.$i, $fila['Fecha de Emision'])
			    ->setCellValue('E'.$i, $fila['Comprobante'])
			    ->setCellValue('F'.$i, $fila['Tipo'])
			    ->setCellValue('G'.$i, $fila['Monto S/'])
			    ->setCellValue('H'.$i,$fila['adelanto'] + $fila['pagado'])
			    ->setCellValue('I'.$i, $fila['Monto S/'] - ($fila['adelanto'] + $fila['pagado']) < 0 ? '0.00' : $fila['Monto S/'] - ($fila['adelanto'] + $fila['pagado']) );
				$i++;
				$j++;

			}

			//$suma = $suma+$fila['Monto S/'];
		}


		$color_style_array = [
		  'font'  => [
		    'color' => ['rgb' => 'FF0000'],
		    'bold' => true,
		  ],
		  'alignment' => [
		  	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
		  ]
		];

		$objPHPExcel->getActiveSheet()->getStyle('I3:I'.$i)->applyFromArray($color_style_array);
		//$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H'.$i, "TOTAL");
		//$objPHPExcel->setActiveSheetIndex(0)->setCellValue('I'.$i, $suma);
		//$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
		//$objPHPExcel->getActiveSheet()->getStyle('H'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('I3:I'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "I".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Deudores');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Deudores.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






