<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRetirosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('retiros', function (Blueprint $table) {
            $table->integer('id_retiro')->autoIncrement();
            $table->integer('id_local');
            $table->integer('id_producto');
            $table->integer('id_usuario');
            $table->string('motivo_retiro', 200)->nullable(); 
            $table->decimal('cantidad_retiro', 9, 2)->nullable(); 
            $table->decimal('monto_perdido', 9, 2)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_local')->references('id_local')->on('local'); 
            $table->foreign('id_producto')->references('id_producto')->on('productos'); 
            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('retiros');
    }
}
