<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Usuario extends Authenticatable
{
    use Notifiable;

    //protected $table = 'usuarios';

    protected $guard = 'usuario';

    protected $primaryKey = 'id_usuario';
    protected $foreignKey = 'id_rol';

    protected $fillable = [
        'id_usuario', 'id_rol', 'id_local', 'username', 'password','nombres', 'apellidos', 'dni','fecha_nacimiento', 'domicilio','email', 'telefono', 'genero', 'url_avatar', 'estado',
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];

    public function rol()
    {
        return $this->belongsTo('App\Models\Rol', 'id_rol');
    }

    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }

}
